importPackage(ru.yandex.misc.db.q);
importPackage(ru.yandex.inside.yt.kosher.cypress);
importPackage(ru.yandex.inside.yt.kosher.tables.types);
importPackage(com.fasterxml.jackson.databind.node);

var databases = Cf.list('addresses', 'ymapsbookmarks1', 'ymapspointshistory1');
var handleCounts = 50;
var ytPageSize = 100000;
var rootFolder = '//home/datasync/geoSuggestDump';

var shards = shardPartitionDataSource.shardManager.getWritableShards();

var jsonNodeFactory = new JsonNodeFactory(false);

var rowMapper = new org.springframework.jdbc.core.RowMapper {
    mapRow: function(rs, rowNum) {
        var node = jsonNodeFactory.objectNode();
        Cf.toList(Tuple2List.fromPairs(
                'user_id', 'uid', 
                'handle', 'handle',
                'rev', 'record_rev', 
                'collection_id', 'collection_id',
                'record_id', 'record_id',
                'dbid', 'database_id',
                'app', 'application_id',
                'jcontent', 'record_data')).forEach(function(tuple) {
                    value = rs.getString(tuple._1);
                    node.put(tuple._2, value == null ? "" : value);
                });
        return node;
    }
}

function getHandles(shard, partitionIndex, offsetHandle) {
    var condition = offsetHandle.map(function (handle) {return ConditionUtils.column("handle").gt(handle);})
            .getOrElse(SqlCondition.trueCondition()).and(ConditionUtils.column("dbid").inSet(databases));
    var limits = SqlLimits.first(handleCounts);
    var order = SqlOrder.orderByColumn("handle");

    var partition = 'databases_' + ru.yandex.misc.lang.StringUtils.leftPad(partitionIndex, 3, '0');

    var query = "SELECT handle FROM " + partition + " " + condition.whereSql() + " "
            + order.toSql() + " "
            + limits.toMysqlLimits();

    return shard.getJdbcTemplate3().queryForList(query, java.lang.String.class, condition.args());
}

function getRecords(shard, partitionIndex, handles) {
    var condition = ConditionUtils.column("handle").inSet(handles);

    var partition = 'p_data_' + ru.yandex.misc.lang.StringUtils.leftPad(partitionIndex, 3, '0');

    var query = "SELECT * FROM " + partition + " " + condition.whereSql();

    return shard.getJdbcTemplate3().query(query, rowMapper, condition.args());
}

function withRetries(action) {
    ru.yandex.commune.util.RetryUtils.retryO(5, action).getOrThrow("failed on reties");
}

function uploadShardPartition(shardIndex, partitionIndex) {
    var shard = shards.get(shardIndex);
    var resultPath = YPath.simple(rootFolder + "/shard" + shardIndex + "partition" + partitionIndex).append(true);

    withRetries(function() {
        dataApiYtClient.cypress().create(resultPath, CypressNodeType.TABLE, true, true);
    });

    var handles = Cf.list();
    var handleOffset = Option.empty();

    var records = Cf.arrayList();

    do {
        handles = getHandles(shard, partitionIndex, handleOffset);
        handleOffset = handles.lastO();

        records.addAll(getRecords(shard, partitionIndex, handles));

        if ((records.size() > ytPageSize) || (handles.isEmpty())) {
            withRetries(function () {
                dataApiYtClient.tables().write(resultPath, new JacksonTableEntryType(false), records);
            }); 
            records = Cf.arrayList();        
        }
    } while (handles.isNotEmpty());
}

// uploadShardPartition(0, 0);
