import sys
import json
import itertools


def do_decode(lines):
    for line in lines:
        yield json.loads(line)


def do_map(rows):
    for row in rows:
        if row.keys() == ['yandex_puid']:
            print json.dumps(row)
        if ('/json/enable_unlimited_autouploading' in row.get('uri', '') and
           row.get('status') == '200'):
            print json.dumps({'yandex_puid': row.get('uid')})


def do_reduce(rows):
    prev_row = {}

    for row in itertools.chain(rows, ({},)):
        if prev_row and prev_row != row:
            print json.dumps(prev_row)

        prev_row = row


if __name__ == '__main__':
    stream = sys.stdin
    stream = do_decode(stream)

    if len(sys.argv) >= 2 and sys.argv[1] == "map":
        do_map(stream)
    elif len(sys.argv) >= 2 and sys.argv[1] == "reduce":
        do_reduce(stream)
    else:
        print >> sys.stderr, "Please, specify proper map or reduce command to execute"
        sys.exit(1)
