#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-

import yt.yson as yson
from yt.wrapper import YtClient
from yql.api.v1.client import YqlClient

from data_appender import DataAppender

from os import getenv

QUERY_TEMPLATE = """
PRAGMA yt.InferSchema;

USE hahn;

INSERT INTO [{output_path}] WITH TRUNCATE

SELECT email FROM [{uids_path}] as uids
JOIN [//home/mpfs-stat/photounlim/email_by_uid] as emails
ON uids.yandex_puid = emails.uid;
"""


def resolve_emails(uids_path, output_path):
    yql_token = getenv('MPFS_STAT_YQL_TOKEN')

    query = QUERY_TEMPLATE.format(output_path=output_path,
                                  uids_path=uids_path)
    with YqlClient(db='hahn', token=yql_token) as yql_client:
        request = yql_client.query(query)
        request.run()


if __name__ == '__main__':
    token = getenv('MPFS_STAT_YT_TOKEN')

    schema = yson.YsonList([
        {"name": "yandex_puid", "type": "string"}
    ])

    data_appender = DataAppender(proxy='hahn',
                                 token=token,
                                 logs_path='//statbox/ydisk-mpfs-access-log',
                                 result_path='//home/mpfs-stat/photounlim/enabled_appendable')

    output_path = data_appender.update(schema, 'get_photounlim_users.py',
                                       reduce_by=['yandex_puid'],
                                       sort_by=['yandex_puid'])

    client = YtClient(proxy='hahn', token=token)
    client.copy(output_path, '//home/mpfs-stat/photounlim/users_to_skip', force=True)

    resolve_emails(output_path, '//home/mpfs-stat/photounlim/users_to_skip_emails')
