package ru.yandex.chemodan.app.djfs.migrator;

import lombok.Builder;
import lombok.Getter;

import ru.yandex.chemodan.app.djfs.core.db.DjfsShardInfo;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardResolver;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

/**
 * @author yappo
 */
@Builder
public class DjfsCleanConfiguration {
    @Getter
    private final DjfsShardInfo.Pg onShardInfo;
    private final PgShardResolver pgShardResolver;
    @Getter
    private final DjfsUid uid;
    @Getter
    private final int baseBatchSize;

    public JdbcTemplate3 shardJdbcTemplate() {
        return pgShardResolver.resolve(onShardInfo);
    }
}
