package ru.yandex.chemodan.app.djfs.migrator;

import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.app.djfs.migrator.tasks.DjfsMigratorCleanTask;
import ru.yandex.chemodan.app.djfs.migrator.tasks.DjfsMigratorCopyTask;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.bazinga.BazingaTaskManager;

//handels are temporal, will used bazinga
@ActionContainer
@RequiredArgsConstructor
public class DjfsMigrationActions {
    private final BazingaTaskManager bazingaTaskManager;
    private final DjfsMigratorYtSupplier migratorYtSupplier;

    @Path(value = "/v1/migrator/schedule/copy", methods = {HttpMethod.POST})
    public void scheduleCopyData(
            @RequestParam("uid") String rawUid,
            @RequestParam("fromShardId") int fromShardId,
            @RequestParam("toShardId") int toShardId,
            @RequestParam("forceActiveUser") Option<Boolean> forceActiveUser
    )
    {
        bazingaTaskManager.schedule(
                new DjfsMigratorCopyTask(DjfsUid.cons(rawUid), fromShardId, toShardId, forceActiveUser.getOrElse(false))
        );
    }

    @Path(value = "/v1/migrator/schedule/clean", methods = {HttpMethod.POST})
    public void scheduleCleanData(
            @RequestParam("uid") String rawUid,
            @RequestParam("fromShardId") int fromShardId,
            @RequestParam("toShardId") int toShardId
    )
    {
        bazingaTaskManager.schedule(new DjfsMigratorCleanTask(DjfsUid.cons(rawUid), fromShardId, toShardId));
    }

    @Path(value = "/v1/migrator/schedule/ytSupply", methods = {HttpMethod.POST})
    public void scheduleYtSupply(
            @RequestParam("path") String path
    )
    {
        migratorYtSupplier.scheduleSupply(path);
    }
}
