package ru.yandex.chemodan.app.djfs.migrator;

public enum DjfsMigrationState {
    START_CLEANING(false),
    SUCCESS_CLEAN(false),
    EXCEPTION_ON_CLEANING(false),
    START_COPYING(false),

    EXCEPTION_ON_COPYING(true),
    COPY_SUCCESS(true),
    USER_IS_ACTIVE(true),
    ALREADY_MIGRATED(true),
    USER_ALREADY_LOCKED_FOR_MIGRATION(true),
    MIGRATION_CONFIG_ERROR(true),
    ;

    private final boolean copyResult;

    DjfsMigrationState(boolean copyResult) {
        this.copyResult = copyResult;
    }

    public boolean isCopyResult() {
        return copyResult;
    }
}
