package ru.yandex.chemodan.app.djfs.migrator;

import lombok.RequiredArgsConstructor;

import ru.yandex.chemodan.app.djfs.core.db.DjfsShardInfo;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardResolver;
import ru.yandex.chemodan.app.djfs.core.db.pg.SharpeiShardResolver;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.app.djfs.core.user.UserNotInitializedException;
import ru.yandex.misc.test.Assert;

/**
 * @author yappo
 */
@RequiredArgsConstructor
public class DjfsMigratorConfigFactory {
    private final PgShardResolver pgShardResolver;
    private final SharpeiShardResolver sharpeiShardResolver;
    private final int baseBatchSize;

    public DjfsCopyConfiguration.DjfsCopyConfigurationBuilder copyConfigBuilder(DjfsUid uid, int srcShardId, int dstShardId) {
        DjfsShardInfo.Pg currentUserShard = new DjfsShardInfo.Pg(sharpeiShardResolver.shardByUid(uid)
                .getOrThrow(() -> new UserNotInitializedException(uid, "no sharpei entry")).getShardId());
        Assert.equals(currentUserShard.getShardId(), srcShardId, "current user shard and srcShard must be same");
        Assert.notEquals(srcShardId, dstShardId, "src shard and dst shard must be different");
        return DjfsCopyConfiguration.builder()
                .uid(uid)
                .srcShardInfo(new DjfsShardInfo.Pg(srcShardId))
                .dstShardInfo(new DjfsShardInfo.Pg(dstShardId))
                .pgShardResolver(pgShardResolver)
                .baseBatchSize(baseBatchSize);
    }

    public DjfsCleanConfiguration.DjfsCleanConfigurationBuilder cleanConfigBuilder(DjfsUid uid, int onShardId) {
        DjfsShardInfo.Pg currentUserShard = new DjfsShardInfo.Pg(sharpeiShardResolver.shardByUid(uid)
                .getOrThrow(() -> new UserNotInitializedException(uid, "no sharpei entry")).getShardId());
        Assert.notEquals(currentUserShard.getShardId(), onShardId, "current user shard and shard to clean must be different");
        return DjfsCleanConfiguration.builder()
                .uid(uid)
                .onShardInfo(new DjfsShardInfo.Pg(onShardId))
                .pgShardResolver(pgShardResolver)
                .baseBatchSize(baseBatchSize);
    }
}
