package ru.yandex.chemodan.app.djfs.migrator;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.djfs.core.db.pg.DjfsPgContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardResolver;
import ru.yandex.chemodan.app.djfs.core.db.pg.SharpeiShardResolver;
import ru.yandex.chemodan.app.djfs.core.lock.LockContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.lock.LockManager;
import ru.yandex.chemodan.app.djfs.core.operations.OperationContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.operations.OperationDao;
import ru.yandex.chemodan.util.sharpei.SharpeiClient;

/**
 * @author yappo
 */
@Import({
        DjfsPgContextConfiguration.class,
        LockContextConfiguration.class,
        OperationContextConfiguration.class
})
public class DjfsMigratorContext {

    @Bean
    public DjfsMigratorConfigFactory djfsMigratorConfigFactory(
            PgShardResolver pgShardResolver, SharpeiShardResolver sharpeiShardResolver,
            @Value("${djfs-migrator.migration.baseBatchSize}") int baseBatchSize)
    {
        return new DjfsMigratorConfigFactory(pgShardResolver, sharpeiShardResolver, baseBatchSize);
    }

    @Bean
    public DjfsMigrator djfsMigrator(DjfsMigratorConfigFactory djfsMigratorConfigFactory, LockManager lockManager,
            SharpeiClient sharpeiClient, SharpeiShardResolver sharpeiShardResolver, OperationDao operationDao) {
        return new DjfsMigrator(djfsMigratorConfigFactory, lockManager, sharpeiClient, sharpeiShardResolver,
                operationDao);
    }
}
