package ru.yandex.chemodan.app.djfs.migrator;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.djfs.core.DjfsMainSupport;
import ru.yandex.chemodan.app.djfs.migrator.tasks.DjfsMigratorFancy;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;

/**
 * @author yappo
 */
public class DjfsMigratorMain extends DjfsMainSupport {

    public static void main(String[] args) {
        DjfsMigratorFancy.enable();
        new DjfsMigratorMain().runMain(args);
    }

    @Override
    public AppName applicationName() {
        return new SimpleAppName("disk", "djfs-migrator");
    }

    @Override
    public ListF<Class<?>> applicationSpecificContextPath() {
        return Cf.list(DjfsMigratorApplicationContext.class);
    }
}
