package ru.yandex.chemodan.app.djfs.migrator;

import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;

/**
 * @author yashunsky
 */
public class DjfsMigratorTaskQueueName {
    public static final int COPYING_QUEUES_COUNT = 100;

    public static final TaskQueueName REGULAR = new TaskQueueName("djfs-migrator-regular");
    public static final TaskQueueName CPU_INTENSIVE = new TaskQueueName("djfs-migrator-cpu-intensive");
    public static final TaskQueueName CRON = new TaskQueueName("djfs-migrator-cron");
    public static final TaskQueueName CLEAN_UP = new TaskQueueName("djfs-migrator-clean-up");
    public static final TaskQueueName YT_SUPPORT = new TaskQueueName("djfs-migrator-yt-support");

    public static TaskQueueName copying(int shardId) {
        return new TaskQueueName("djfs-migrator-copying-" + shardId % COPYING_QUEUES_COUNT);
    }

    public static TaskId toTaskId(TaskQueueName queueName) {
        return new TaskId(queueName.getName());
    }
}
