package ru.yandex.chemodan.app.djfs.migrator;

import lombok.AccessLevel;
import lombok.Data;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

@RequiredArgsConstructor(access = AccessLevel.PRIVATE)
@Getter
public class PgSchema {
    private final MapF<String, Table> tables;

    public static PgSchema build(JdbcTemplate3 shard) {
        ListF<Table> tables = shard.query(
                "SELECT table_name, column_name, data_type, udt_name, udt_schema FROM information_schema.columns WHERE table_schema = 'disk'",
                (rs, i) -> Tuple2.tuple(
                        rs.getString("table_name"),
                        new Column(
                                rs.getString("column_name"),
                                rs.getString("data_type"),
                                rs.getString("udt_schema"),
                                rs.getString("udt_name")
                        )
                )
        )
                .groupByMapValues(Tuple2::get1, Tuple2::get2)
                .mapEntries(Table::new);
        return new PgSchema(tables.toMapMappingToKey(Table::getName));
    }

    @RequiredArgsConstructor(access = AccessLevel.PRIVATE)
    @Getter
    public static class Table {
        private final String name;
        private final ListF<Column> columns;
    }

    @Data
    public static class Column {
        private final String name;
        private final String dataType;
        private final String userDefinedTypeSchema;
        private final String userDefinedTypeName;
    }
}
