package ru.yandex.chemodan.app.djfs.migrator.migrations;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.app.djfs.migrator.DjfsCopyConfiguration;
import ru.yandex.chemodan.app.djfs.migrator.PgSchema;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;
import ru.yandex.misc.test.Assert;

public class DjfsCleanButNotCopyTableMigration implements DjfsTableMigration {
    private final String tableName;

    public DjfsCleanButNotCopyTableMigration(String tableName) {
        Assert.notEmpty(tableName, "table name is empty");
        this.tableName = tableName;
    }

    @Override
    public void runCopying(DjfsCopyConfiguration migrationConf, PgSchema databaseSchema,
            Runnable callback) {
        //do nothing
    }

    @Override
    public void checkAllCopied(DjfsCopyConfiguration migrationConf,
            PgSchema sourceSchema) {
        //do nothing
    }

    @Override
    public void cleanData(JdbcTemplate3 shard, DjfsUid uid, int batchSize) {
        DjfsMigrationUtil.withDisabledMigrationLockCheck(shard, () ->
                shard.update("DELETE FROM disk." + tableName + " WHERE uid = ?", uid.asLong())
        );
    }

    @Override
    public ListF<String> tables() {
        return Cf.list(tableName);
    }

}
