package ru.yandex.chemodan.app.djfs.migrator.migrations;

import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.app.djfs.migrator.DjfsCopyConfiguration;
import ru.yandex.chemodan.app.djfs.migrator.PgSchema;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

public class DjfsFoldersMigration extends DjfsTableWithSelfReferenceMigration {
    public DjfsFoldersMigration() {
        super("folders", "fid", "parent_fid");
    }

    @Override
    public void checkAllCopied(DjfsCopyConfiguration migrationConf,
            PgSchema sourceSchema)
    {
        JdbcTemplate3 srcShard = migrationConf.srcShardJdbcTemplate();
        JdbcTemplate3 dstShard = migrationConf.dstShardJdbcTemplate();

        DjfsUid uid = migrationConf.getUid();

        DjfsMigrationUtil.checkSameDataInTableForUidWithBatches(
                srcShard, dstShard, "folders", "fid", uid, migrationConf.getBaseBatchSize(), sourceSchema
        );
    }
}
