package ru.yandex.chemodan.app.djfs.migrator.tasks;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.djfs.migrator.DjfsMigratorTaskQueueName;
import ru.yandex.chemodan.app.djfs.migrator.DjfsMigratorYtSupplier;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author yashunsky
 */
public class DjfsMigratorYtSupplyTask extends OnetimeTaskSupport<DjfsMigratorYtSupplyTask.Parameters> {
    private final DjfsMigratorYtSupplier migratorYtSupplier;

    public DjfsMigratorYtSupplyTask(String path, long lowerIndex) {
        super(new DjfsMigratorYtSupplyTask.Parameters(path, lowerIndex));
        migratorYtSupplier = null;
    }

    public DjfsMigratorYtSupplyTask(DjfsMigratorYtSupplier migratorYtSupplier)
    {
        super(DjfsMigratorYtSupplyTask.Parameters.class);
        this.migratorYtSupplier = migratorYtSupplier;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) {
        migratorYtSupplier.addUsersFromYt(parameters.path, parameters.lowerIndex);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(12);
    }

    @Override
    public TaskQueueName queueName() {
        return DjfsMigratorTaskQueueName.YT_SUPPORT;
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters {
        private final String path;
        private long lowerIndex;
    }
}
