package ru.yandex.chemodan.app.djfs.api;

import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.alice.AliceContextConfiguration;
import ru.yandex.chemodan.app.djfs.api.ratelimiter.DjfsRateLimiterContextConfiguration;
import ru.yandex.chemodan.app.djfs.api.tvm2.DjfsTvm2ServletFilterContextConfiguration;
import ru.yandex.chemodan.bazinga.PgBazingaStorageConfigurationContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.chemodan.boot.admin.ChemodanAdminDaemonContextConfiguration;
import ru.yandex.chemodan.queller.worker.CeleryTaskManagerContextConfiguration;
import ru.yandex.chemodan.util.web.A3JettyContextConfiguration;
import ru.yandex.chemodan.zk.registries.tvm.ZkTvm2ContextConfiguration;
import ru.yandex.commune.bazinga.pg.context.PgBazingaClientContextConfiguration;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        A3JettyContextConfiguration.class,
        CeleryTaskManagerContextConfiguration.class,
        DjfsTvm2ServletFilterContextConfiguration.class,
        DjfsRateLimiterContextConfiguration.class,
        ZkTvm2ContextConfiguration.class,
        ChemodanCommonContextConfiguration.class,
        ChemodanAdminDaemonContextConfiguration.class,
        PgBazingaStorageConfigurationContextConfiguration.class,
        PgBazingaClientContextConfiguration.class,
        AliceContextConfiguration.class,
})
public class DjfsApiContextConfiguration extends DjfsApiBaseContextConfiguration {

}
