package ru.yandex.chemodan.app.djfs.api.ratelimiter;

import java.net.URI;

import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.ratelimiter.RateLimiterClient;
import ru.yandex.chemodan.ratelimiter.RateLimiterHttpClientContextConfiguration;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author yappo
 */
@Configuration
@Import({
        RateLimiterHttpClientContextConfiguration.class,
})
public class DjfsRateLimiterContextConfiguration {
    private final static Logger logger = LoggerFactory.getLogger(DjfsRateLimiterContextConfiguration.class);

    @Bean
    protected DjfsRateLimiterFilter internalRateLimiterFilter(
            @Value("${ratelimiter.uri}") URI ratelimiterUri,
            @Value("${ratelimiter.filter.pattern:-*}") String ratelimiterUrlPattern,
            @Value("${djfs-filter.ratelimiter.mode:-DISABLED}") DjfsRatelimiterFilterMode ratelimiterFilterMode,
            @Value("${djfs-filter.ratelimiter.group}") String ratelimiterGroup,
            HttpClient client)
    {
        RateLimiterClient rateLimiterClient = new RateLimiterClient(client, ratelimiterUri, ratelimiterGroup, false);
        if (ratelimiterFilterMode == DjfsRatelimiterFilterMode.DISABLED) {
            logger.warn("RatelimiterFilter is disabled, validation will be skipped");
            return new DjfsRateLimiterDisabled(rateLimiterClient, ratelimiterUrlPattern);
        }
        return new DjfsRateLimiterFilter(rateLimiterClient, ratelimiterUrlPattern);
    }
}
