package ru.yandex.chemodan.app.djfs.api.ratelimiter;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.core.annotation.Order;
import org.springframework.web.filter.OncePerRequestFilter;

import ru.yandex.chemodan.ratelimiter.RateLimiterClient;
import ru.yandex.inside.passport.tvm2.web.Tvm2Filter;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.net.HostnameUtils;
import ru.yandex.misc.web.servlet.SelfMappedFilter;

/**
 * @author yappo
 */
@Order(2)
public class DjfsRateLimiterFilter extends OncePerRequestFilter implements SelfMappedFilter {
    private static final Logger logger = LoggerFactory.getLogger(Tvm2Filter.class);

    private static final String TVM_CLIENT_ID_ATTR = "TVM-ClientId";

    private final String ratelimiterUrlPattern;
    private final RateLimiterClient rateLimiterClient;

    DjfsRateLimiterFilter(RateLimiterClient rateLimiterClient, String ratelimiterUrlPattern) {
        this.rateLimiterClient = rateLimiterClient;
        this.ratelimiterUrlPattern = ratelimiterUrlPattern;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request,
            HttpServletResponse response,
            FilterChain filterChain) throws ServletException, IOException
    {
        Object sourceClientIdObject = request.getAttribute(TVM_CLIENT_ID_ATTR);
        if (sourceClientIdObject == null) {
            logger.warn("No tvm2 source client id is presented in request, skipping");
            filterChain.doFilter(request, response);
            return;
        }
        Integer sourceClientId = (Integer) sourceClientIdObject;
        if (rateLimiterClient.queryLimit(HostnameUtils.localHostname() + ":" + sourceClientId.toString()).proceed) {
            filterChain.doFilter(request, response);
        } else {
            response.sendError(HttpStatus.SC_429_TOO_MANY_REQUESTS);
        }
    }

    @Override
    public String getUrlPattern() {
        return ratelimiterUrlPattern;
    }
}
