package ru.yandex.chemodan.app.djfs.api.tvm2;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.core.annotation.Order;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.inside.passport.tvm2.web.Tvm2CheckingMode;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author yappo
 */
@Order(1)
public class DjfsTvm2FilterDisabled extends DjfsTvm2Filter {

    public DjfsTvm2FilterDisabled(Tvm2 tvm2, Tvm2CheckingMode tvm2Mode, String tvm2ServletUrlPattern,
            ListF<Function<HttpServletRequestX, Option<String>>> uidFetchers,
            ListF<String> excludedPaths) {
        super(tvm2, tvm2Mode, tvm2ServletUrlPattern, uidFetchers, excludedPaths);
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request,
            HttpServletResponse response,
            FilterChain filterChain) throws ServletException, IOException
    {
        filterChain.doFilter(request, response);
    }
}
