package ru.yandex.chemodan.app.djfs.api.tvm2;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.inside.passport.tvm2.web.Tvm2BaseContextConfiguration;
import ru.yandex.inside.passport.tvm2.web.Tvm2CheckingMode;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.parse.CommaSeparated;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author yappo
 * copy-paste from ru.yandex.inside.passport.tvm2.web.Tvm2ServletFilterContextConfiguration
 */
@Configuration
@Import(Tvm2BaseContextConfiguration.class)
public class DjfsTvm2ServletFilterContextConfiguration {

    private final static Logger
            logger = LoggerFactory.getLogger(ru.yandex.inside.passport.tvm2.web.Tvm2ServletFilterContextConfiguration.class);

    public final static String X_UID = "X-Uid";

    @Bean
    @Primary
    protected DjfsTvm2Filter internalAccessFilter(
            @Value("${tvm.filter.mode:-DISABLED}") Tvm2CheckingMode tvm2Mode,
            @Value("${tvm.filter.pattern:-*}") String tvm2ServletUrlPattern,
            @Value("${tvm.filter.uid.param:-__uid}") String uidParamName,
            @Value("${tvm.filter.excluded-paths:-}") CommaSeparated excludedPaths,
            Tvm2 tvm2)
    {
        ListF<Function<HttpServletRequestX, Option<String>>> uidFetchers = Cf.list(
                requestX -> requestX.getHeaderO(X_UID),
                requestX -> requestX.getParameterO(uidParamName)
        );
        if (tvm2 == null || tvm2Mode == Tvm2CheckingMode.DISABLED) {
            logger.warn("Tvm is not initialised or disabled, validation will be skipped");
            Validate.isTrue(tvm2Mode != Tvm2CheckingMode.FULL,
                    "Tvm is required by tvm2Mode property: " + tvm2Mode);
            return new DjfsTvm2FilterDisabled(tvm2, tvm2Mode, tvm2ServletUrlPattern, uidFetchers, excludedPaths.list);
        }
        logger.info("About to start filter with mode: {}, pattern: {}, uid: {}",
                tvm2Mode, tvm2ServletUrlPattern, uidParamName);
        return new DjfsTvm2Filter(tvm2, tvm2Mode, tvm2ServletUrlPattern, uidFetchers, excludedPaths.list);
    }
}
