package ru.yandex.chemodan.app.djfs.core;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.djfs.core.album.AlbumContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.billing.BillingContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.changelog.ChangelogContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.client.DjfsClientContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.db.DjfsDbContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.diskinfo.DiskInfoContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.filesystem.FilesystemContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.globalgallery.GlobalGalleryContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.history.HistoryContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.index.IndexContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.lastfiles.LastFilesCacheUpdater;
import ru.yandex.chemodan.app.djfs.core.legacy.LegacyContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.lenta.LentaContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.lock.LockContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.notification.NotificationContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.operations.OperationContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.overdraft.OverdraftContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.publication.PublicationContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.share.ShareContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.user.UserContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.versioning.VersioningContextConfiguration;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.thread.factory.ThreadNameIndexThreadFactory;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        AlbumContextConfiguration.class,
        BillingContextConfiguration.class,
        ChangelogContextConfiguration.class,
        DiskInfoContextConfiguration.class,
        DjfsDbContextConfiguration.class,
        DjfsClientContextConfiguration.class,
        EventManagerContextConfiguration.class,
        FilesystemContextConfiguration.class,
        HistoryContextConfiguration.class,
        IndexContextConfiguration.class,
        LastFilesCacheUpdater.class,
        LegacyContextConfiguration.class,
        LockContextConfiguration.class,
        NotificationContextConfiguration.class,
        OperationContextConfiguration.class,
        PublicationContextConfiguration.class,
        ShareContextConfiguration.class,
        UserContextConfiguration.class,
        VersioningContextConfiguration.class,
        LentaContextConfiguration.class,
        GlobalGalleryContextConfiguration.class,
        OverdraftContextConfiguration.class
})
public class DjfsCoreContextConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(DjfsCoreContextConfiguration.class);

    @Bean
    public ExecutorService standardExecutorService() {
        return new ThreadPoolExecutor(5, 10, 1, TimeUnit.MINUTES, new ArrayBlockingQueue<>(500),
                new ThreadNameIndexThreadFactory("StandardExecutorService"),
                new ThreadPoolExecutor.CallerRunsPolicy() {
                    public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                        logger.warn("ExecutorService queue full, executing synchronously");
                        super.rejectedExecution(r, e);
                    }
                });
    }

    @Bean
    public DownloadUrlGenerator downloadUrlGenerator(
            @Value("${download-url-generator.base-url}") String baseUrl,
            @Value("${download-url-generator.hmac-token-password}") String hmacTokenPassword,
            @Value("${download-url-generator.link-default-expiration-period}") Duration defaultExpirationPeriod,
            LegacyMpfsAes legacyMpfsAes)
    {
        return new DownloadUrlGenerator(
                baseUrl,
                hmacTokenPassword,
                defaultExpirationPeriod,
                legacyMpfsAes
        );
    }
}
