package ru.yandex.chemodan.app.djfs.core;

import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.springframework.context.ConfigurableApplicationContext;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.djfs.core.client.ActivateRealClient;
import ru.yandex.chemodan.app.djfs.core.db.mongo.ActivateRealMongo;
import ru.yandex.chemodan.app.djfs.core.db.pg.ActivateRealPg;
import ru.yandex.chemodan.app.djfs.core.logging.LayoutFactory;
import ru.yandex.chemodan.app.djfs.core.web.DjfsTskvLog4jRequestLog;
import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanMainSupport;
import ru.yandex.chemodan.log.Log4jHelper;
import ru.yandex.misc.log.mlf.Level;

/**
 * @author eoshch
 */
public abstract class DjfsMainSupport extends ChemodanMainSupport {
    @Override
    public ListF<Class<?>> applicationSpecificContextPath() {
        return Cf.list(ChemodanCommonContextConfiguration.class, DjfsCoreContextConfiguration.class);
    }

    @Override
    protected void configureLogger() {
        PluginManager.addPackage("ru.yandex.chemodan.log.plugins");

        Log4jHelper.rootLoggerBuilder().appName(applicationName()).miscLevel(Level.INFO).postfix("-default")
                .measureExceptions(false)
                .layout(LayoutFactory.defaultLayout(applicationName())).build();

        Log4jHelper.accessLoggerBuilder().appName(applicationName())
                .layout(DjfsTskvLog4jRequestLog.layout(applicationName())).build();

        Log4jHelper.appenderBuilder().appName(applicationName()).level(Level.INFO).name("requests")
                .layout(LayoutFactory.requestsLayout(applicationName())).postfix("-requests").buffSize(1024*1024).build();

        Log4jHelper.appenderBuilder().appName(applicationName()).level(Level.INFO).name("error")
                .layout(LayoutFactory.errorLayout(applicationName())).postfix("-error").build();

        Log4jHelper.appenderBuilder().appName(applicationName()).level(Level.INFO).name("event-history")
                .layout(LayoutFactory.eventHistoryLayout()).postfix("-event-history").build();
    }

    @Override
    protected void postProcessApplicationContextBeforeRefresh(ConfigurableApplicationContext context) {
        super.postProcessApplicationContextBeforeRefresh(context);
        context.getEnvironment().addActiveProfile(ActivateRealClient.PROFILE);
        context.getEnvironment().addActiveProfile(ActivateRealMongo.PROFILE);
        context.getEnvironment().addActiveProfile(ActivateRealPg.PROFILE);
    }
}
