package ru.yandex.chemodan.app.djfs.core;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FileDjfsResource;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.MediaType;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.mediatype.MediaTypeUtils;

public enum DownloadUrlAdditionalField {

    ETAG("etag") {
        @Override
        public Option<String> getValue(FileDjfsResource file) {
            return Option.of(file.getMd5());
        }
    },
    FSIZE("fsize") {
        @Override
        public Option<String> getValue(FileDjfsResource file) {
            if (file.getSize() > 0) {
                return Option.of(String.valueOf(file.getSize()));
            }
            return Option.empty();
        }
    },
    HID("hid") {
        @Override
        public Option<String> getValue(FileDjfsResource file) {
            return Option.of(file.getHid());
        }
    },
    MEDIA_TYPE("media_type") {
        @Override
        public Option<String> getValue(FileDjfsResource file) {
            return MediaTypeUtils.getFileMediaTypeO(file).map(MediaType::getStringRepresentation);
        }
    };

    public static final SetF<DownloadUrlAdditionalField> ALL = Cf.set(DownloadUrlAdditionalField.values());

    private final String name;

    DownloadUrlAdditionalField(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract Option<String> getValue(FileDjfsResource file);
}
