package ru.yandex.chemodan.app.djfs.core;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;

/**
 * @author eoshch
 */
public class EventManager {
    public interface Event {
    }

    @Target(ElementType.METHOD)
    @Retention(RetentionPolicy.RUNTIME)
    @EventListener
    public @interface EventHandler {
    }

    private final ApplicationEventPublisher publisher;

    public EventManager(ApplicationEventPublisher publisher)
    {
        this.publisher = publisher;
    }

    public void send(Event event) {
        publisher.publishEvent(event);
    }
}
