package ru.yandex.chemodan.app.djfs.core;

import java.util.UUID;

import lombok.RequiredArgsConstructor;
import lombok.Value;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsFileId;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FileDjfsResource;

@Value
@RequiredArgsConstructor
public class FilenamePreviewStidMimetypeVersionFileId {
    private Option<String> previewStid;
    private Option<String> mimetype;
    private String filename;
    private final Option<Long> version;
    private final UUID id;
    private final Option<DjfsFileId> fileId;

    public FilenamePreviewStidMimetypeVersionFileId(FileDjfsResource file) {
        previewStid = file.getPreviewStid();
        mimetype = file.getMimetype();
        filename = file.getPath().getName();
        version = file.getVersion();
        id = file.getId();
        fileId = file.getFileId();
    }
}
