package ru.yandex.chemodan.app.djfs.core;

import java.security.GeneralSecurityException;
import java.util.Base64;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.chemodan.app.djfs.core.filesystem.model.exception.InvalidClientInputDjfsPublicHashException;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.exception.InvalidDjfsResourcePathException;
import ru.yandex.chemodan.app.djfs.core.legacy.exception.LegacyDecryptionErrorException;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.lang.CharsetUtils;

public class LegacyMpfsAes {
    private static final int DEFAULT_BLOCK_SIZE = 32;
    private static final char PADDING_SYMBOL = '{';
    private SecretKey secretKey;

    public LegacyMpfsAes(String key) {
        byte[] SECRET = key.getBytes(CharsetUtils.UTF8_CHARSET);
        secretKey = new SecretKeySpec(SECRET, "AES");
    }

    public String encrypt(String s) {
        String plainData = StringUtils.rightPad(
                s, s.length() + DEFAULT_BLOCK_SIZE - s.length() % DEFAULT_BLOCK_SIZE, PADDING_SYMBOL
        );

        try {
            Cipher c = Cipher.getInstance("AES/ECB/NoPadding");
            c.init(Cipher.ENCRYPT_MODE, secretKey);
            return Base64.getUrlEncoder().encodeToString(c.doFinal(CharsetUtils.encodeUtf8ToArray(plainData)));
        } catch (GeneralSecurityException e) {
            throw ExceptionUtils.translate(e);
        }
    }

    public String decrypt(String hash) {
        try {
            hash = StringUtils.substringBefore(hash, "=").replaceAll("\\s", ""); //fix several broken hashes
            Cipher c = Cipher.getInstance("AES/ECB/NoPadding");
            c.init(Cipher.DECRYPT_MODE, secretKey);
            return StringUtils.stripEnd(CharsetUtils.decodeUtf8(c.doFinal(Base64.getDecoder().decode(hash))),
                    String.valueOf(PADDING_SYMBOL));
        } catch (GeneralSecurityException e) {
            throw new InvalidClientInputDjfsPublicHashException(
                    new StringBuilder("Wrong hash: ").append(hash).append(". ").append(e).toString());
        } catch (IllegalArgumentException e) {
            throw new LegacyDecryptionErrorException(new InvalidDjfsResourcePathException(
                    new StringBuilder("Wrong hash: ").append(hash).append(". ").append(e).toString()));
        }
    }
}
