package ru.yandex.chemodan.app.djfs.core;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.internal.NotImplementedException;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.MediaType;

public final class MediaTypeResolver {

    private MediaTypeResolver() {
        throw new NotImplementedException();
    }

    public static Option<MediaType> resolve(DjfsResourcePath path, String mimetype) {
        return resolve(path, Option.of(mimetype));
    }

    public static Option<MediaType> resolve(DjfsResourcePath path, Option<String> mimetypeO) {
        return mediaTypeByExtension.getO(path.getExtensionByAfterLastDot()).orElse(mimetypeO.filterMap(mediaTypeByMimetype::getO));
    }

    private static final MapF<String, MediaType> mediaTypeByMimetype = Tuple2List.<String, MediaType>fromPairs(
            "audio/mpeg", MediaType.AUDIO,
            "audio/x-scpls", MediaType.AUDIO,

            "application/x-7z-compressed", MediaType.COMPRESSED,
            "application/x-apple-diskimage", MediaType.COMPRESSED,
            "application/x-tar", MediaType.COMPRESSED,
            "application/zip", MediaType.COMPRESSED,

            "application/octet-stream", MediaType.DATA,
            "application/vnd.openxmlformats-officedocument.presentationml.template", MediaType.DATA,
            "text/calendar", MediaType.DATA,
            "text/csv", MediaType.DATA,
            "text/xml", MediaType.DATA,

            "application/msword", MediaType.DOCUMENT,
            "application/pdf", MediaType.DOCUMENT,
            "application/rtf", MediaType.DOCUMENT,
            "application/vnd.ms-excel", MediaType.DOCUMENT,
            "application/vnd.ms-powerpoint", MediaType.DOCUMENT,
            "application/vnd.oasis.opendocument.presentation", MediaType.DOCUMENT,
            "application/vnd.oasis.opendocument.spreadsheet", MediaType.DOCUMENT,
            "application/vnd.oasis.opendocument.text", MediaType.DOCUMENT,
            "application/vnd.openxmlformats-officedocument.presentationml.presentation", MediaType.DOCUMENT,
            "application/vnd.openxmlformats-officedocument.presentationml.slideshow", MediaType.DOCUMENT,
            "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", MediaType.DOCUMENT,
            "application/vnd.openxmlformats-officedocument.wordprocessingml.document", MediaType.DOCUMENT,
            "application/vnd.openxmlformats-officedocument.wordprocessingml.template", MediaType.DOCUMENT,

            "video/x-flv", MediaType.FLASH,

            "application/vnd.oasis.opendocument.graphics", MediaType.IMAGE,
            "image/gif", MediaType.IMAGE,
            "image/jpeg", MediaType.IMAGE,
            "image/png", MediaType.IMAGE,
            "image/svg+xml", MediaType.IMAGE,
            "image/x-canon-cr2", MediaType.IMAGE,
            "image/x-nikon-nef", MediaType.IMAGE,

            "application/x-msi", MediaType.SETTINGS,

            "text/plain", MediaType.TEXT,

            "video/3gpp", MediaType.VIDEO,
            "video/mp4", MediaType.VIDEO,
            "video/x-matroska", MediaType.VIDEO,
            "video/x-ms-wmv", MediaType.VIDEO,

            "application/x-java-jnlp-file", MediaType.WEB
    ).toMap();

    private static final MapF<String, MediaType> mediaTypeByExtension = Tuple2List.<String, MediaType>fromPairs(
            "all", MediaType.AUDIO,
            "nwc", MediaType.AUDIO,
            "mws", MediaType.AUDIO,
            "aud", MediaType.AUDIO,
            "cmf", MediaType.AUDIO,
            "wfd", MediaType.AUDIO,
            "med", MediaType.AUDIO,
            "xfs", MediaType.AUDIO,
            "akp", MediaType.AUDIO,
            "txw", MediaType.AUDIO,
            "aup", MediaType.AUDIO,
            "wus", MediaType.AUDIO,
            "wut", MediaType.AUDIO,
            "band", MediaType.AUDIO,
            "l", MediaType.AUDIO,
            "dss", MediaType.AUDIO,
            "smp", MediaType.AUDIO,
            "dsm", MediaType.AUDIO,
            "ra", MediaType.AUDIO,
            "dsf", MediaType.AUDIO,
            "smf", MediaType.AUDIO,
            "ntn", MediaType.AUDIO,
            "vqf", MediaType.AUDIO,
            "syx", MediaType.AUDIO,
            "toc", MediaType.AUDIO,
            "ktp", MediaType.AUDIO,
            "ram", MediaType.AUDIO,
            "usflib", MediaType.AUDIO,
            "dm", MediaType.AUDIO,
            "bap", MediaType.AUDIO,
            "mus", MediaType.AUDIO,
            "omg", MediaType.AUDIO,
            "omf", MediaType.AUDIO,
            "wv", MediaType.AUDIO,
            "uni", MediaType.AUDIO,
            "mpga", MediaType.AUDIO,
            "wfb", MediaType.AUDIO,
            "ais", MediaType.AUDIO,
            "wfp", MediaType.AUDIO,
            "aif", MediaType.AUDIO,
            "it", MediaType.AUDIO,
            "kin", MediaType.AUDIO,
            "thx", MediaType.AUDIO,
            "wproj", MediaType.AUDIO,
            "wwu", MediaType.AUDIO,
            "pls", MediaType.AUDIO,
            "qcp", MediaType.AUDIO,
            "pla", MediaType.AUDIO,
            "sou", MediaType.AUDIO,
            "ahx", MediaType.AUDIO,
            "dewf", MediaType.AUDIO,
            "mt2", MediaType.AUDIO,
            "gig", MediaType.AUDIO,
            "xt", MediaType.AUDIO,
            "wax", MediaType.AUDIO,
            "wav", MediaType.AUDIO,
            "mtp", MediaType.AUDIO,
            "mti", MediaType.AUDIO,
            "mtm", MediaType.AUDIO,
            "mte", MediaType.AUDIO,
            "fsm", MediaType.AUDIO,
            "rol", MediaType.AUDIO,
            "f3r", MediaType.AUDIO,
            "dig", MediaType.AUDIO,
            "msv", MediaType.AUDIO,
            "jam", MediaType.AUDIO,
            "wvc", MediaType.AUDIO,
            "ult", MediaType.AUDIO,
            "caf", MediaType.AUDIO,
            "ma1", MediaType.AUDIO,
            "snd", MediaType.AUDIO,
            "sw", MediaType.AUDIO,
            "sb", MediaType.AUDIO,
            "sf", MediaType.AUDIO,
            "sd", MediaType.AUDIO,
            "lso", MediaType.AUDIO,
            "ulaw", MediaType.AUDIO,
            "gtp", MediaType.AUDIO,
            "xi", MediaType.AUDIO,
            "xm", MediaType.AUDIO,
            "xp", MediaType.AUDIO,
            "alaw", MediaType.AUDIO,
            "pna", MediaType.AUDIO,
            "copy", MediaType.AUDIO,
            "d01", MediaType.AUDIO,
            "d00", MediaType.AUDIO,
            "r", MediaType.AUDIO,
            "prg", MediaType.AUDIO,
            "rmi", MediaType.AUDIO,
            "kmp", MediaType.AUDIO,
            "xmi", MediaType.AUDIO,
            "rmx", MediaType.AUDIO,
            "rmf", MediaType.AUDIO,
            "esps", MediaType.AUDIO,
            "pat", MediaType.AUDIO,
            "pac", MediaType.AUDIO,
            "wpk", MediaType.AUDIO,
            "k26", MediaType.AUDIO,
            "k25", MediaType.AUDIO,
            "psm", MediaType.AUDIO,
            "amr", MediaType.AUDIO,
            "ac3", MediaType.AUDIO,
            "8svx", MediaType.AUDIO,
            "al", MediaType.AUDIO,
            "au", MediaType.AUDIO,
            "u", MediaType.AUDIO,
            "cpr", MediaType.AUDIO,
            "ptm", MediaType.AUDIO,
            "mp2", MediaType.AUDIO,
            "mp3", MediaType.AUDIO,
            "mp1", MediaType.AUDIO,
            "pts", MediaType.AUDIO,
            "wma", MediaType.AUDIO,
            "mpd", MediaType.AUDIO,
            "mpc", MediaType.AUDIO,
            "mpa", MediaType.AUDIO,
            "far", MediaType.AUDIO,
            "mpu", MediaType.AUDIO,
            "uwf", MediaType.AUDIO,
            "sc2", MediaType.AUDIO,
            "pbf", MediaType.AUDIO,
            "mp_", MediaType.AUDIO,
            "sprg", MediaType.AUDIO,
            "tfmx", MediaType.AUDIO,
            "mmf", MediaType.AUDIO,
            "flac", MediaType.AUDIO,
            "sseq", MediaType.AUDIO,
            "csh", MediaType.AUDIO,
            "iti", MediaType.AUDIO,
            "fff", MediaType.AUDIO,
            "its", MediaType.AUDIO,
            "wrk", MediaType.AUDIO,
            "pcm", MediaType.AUDIO,
            "pca", MediaType.AUDIO,
            "okt", MediaType.AUDIO,
            "cel", MediaType.AUDIO,
            "8med", MediaType.AUDIO,
            "sbi", MediaType.AUDIO,
            "koz", MediaType.AUDIO,
            "aa3", MediaType.AUDIO,
            "dfc", MediaType.AUDIO,
            "aac", MediaType.AUDIO,
            "gp4", MediaType.AUDIO,
            "gp5", MediaType.AUDIO,
            "stx", MediaType.AUDIO,
            "efq", MediaType.AUDIO,
            "efs", MediaType.AUDIO,
            "efv", MediaType.AUDIO,
            "efk", MediaType.AUDIO,
            "efa", MediaType.AUDIO,
            "efe", MediaType.AUDIO,
            "kar", MediaType.AUDIO,
            "cda", MediaType.AUDIO,
            "669", MediaType.AUDIO,
            "rtm", MediaType.AUDIO,
            "rti", MediaType.AUDIO,
            "dtm", MediaType.AUDIO,
            "rfl", MediaType.AUDIO,
            "pvc", MediaType.AUDIO,
            "wow", MediaType.AUDIO,
            "swa", MediaType.AUDIO,
            "nrt", MediaType.AUDIO,
            "voc", MediaType.AUDIO,
            "vox", MediaType.AUDIO,
            "syh", MediaType.AUDIO,
            "syw", MediaType.AUDIO,
            "gsm", MediaType.AUDIO,
            "m4r", MediaType.AUDIO,
            "m4p", MediaType.AUDIO,
            "m4b", MediaType.AUDIO,
            "m4a", MediaType.AUDIO,
            "f32", MediaType.AUDIO,
            "sd2", MediaType.AUDIO,
            "nsa", MediaType.AUDIO,
            "nst", MediaType.AUDIO,
            "mka", MediaType.AUDIO,
            "fzv", MediaType.AUDIO,
            "fzb", MediaType.AUDIO,
            "fzf", MediaType.AUDIO,
            "sdx", MediaType.AUDIO,
            "uw", MediaType.AUDIO,
            "ub", MediaType.AUDIO,
            "df2", MediaType.AUDIO,
            "nap", MediaType.AUDIO,
            "dvf", MediaType.AUDIO,
            "svx", MediaType.AUDIO,
            "wave", MediaType.AUDIO,
            "ulw", MediaType.AUDIO,
            "ssnd", MediaType.AUDIO,
            "bdd", MediaType.AUDIO,
            "m3u", MediaType.AUDIO,
            "ape", MediaType.AUDIO,
            "usf", MediaType.AUDIO,
            "8cm", MediaType.AUDIO,
            "dwd", MediaType.AUDIO,
            "sid", MediaType.AUDIO,
            "vmf", MediaType.AUDIO,
            "vmd", MediaType.AUDIO,
            "tsp", MediaType.AUDIO,
            "6cm", MediaType.AUDIO,
            "sng", MediaType.AUDIO,
            "cwp", MediaType.AUDIO,
            "bwf", MediaType.AUDIO,
            "midi", MediaType.AUDIO,
            "s3m", MediaType.AUDIO,
            "s3i", MediaType.AUDIO,
            "rsn", MediaType.AUDIO,
            "ogg", MediaType.AUDIO,
            "sf2", MediaType.AUDIO,
            "mid", MediaType.AUDIO,
            "sfl", MediaType.AUDIO,
            "sfk", MediaType.AUDIO,
            "ksf", MediaType.AUDIO,
            "ksc", MediaType.AUDIO,
            "shn", MediaType.AUDIO,
            "sppack", MediaType.AUDIO,
            "dls", MediaType.AUDIO,
            "miniusf", MediaType.AUDIO,
            "w01", MediaType.AUDIO,
            "vrf", MediaType.AUDIO,
            "g721", MediaType.AUDIO,
            "g723", MediaType.AUDIO,
            "rbs", MediaType.AUDIO,
            "g726", MediaType.AUDIO,
            "avr", MediaType.AUDIO,
            "f2r", MediaType.AUDIO,
            "f64", MediaType.AUDIO,
            "phy", MediaType.AUDIO,
            "aiff", MediaType.AUDIO,
            "aifc", MediaType.AUDIO,
            "4mp", MediaType.AUDIO,
            "dcm", MediaType.AUDIO,
            "dcf", MediaType.AUDIO,
            "krz", MediaType.AUDIO,
            "vag", MediaType.AUDIO,
            "ear", MediaType.AUDIO,
            "lvp", MediaType.AUDIO,
            "dmf", MediaType.AUDIO,
            "ins", MediaType.AUDIO,
            "zvd", MediaType.AUDIO,

            "mem", MediaType.BACKUP,
            "nbk", MediaType.BACKUP,
            "dov", MediaType.BACKUP,
            "bac", MediaType.BACKUP,
            "bak", MediaType.BACKUP,
            "bps", MediaType.BACKUP,
            "old", MediaType.BACKUP,
            "qic", MediaType.BACKUP,
            "llx", MediaType.BACKUP,
            "iv2i", MediaType.BACKUP,
            "fbf", MediaType.BACKUP,
            "tbk", MediaType.BACKUP,
            "gho", MediaType.BACKUP,
            "ori", MediaType.BACKUP,
            "$db", MediaType.BACKUP,
            "v2i", MediaType.BACKUP,
            "cbk", MediaType.BACKUP,
            "abk", MediaType.BACKUP,
            "nb7", MediaType.BACKUP,
            "oyx", MediaType.BACKUP,
            "bkf", MediaType.BACKUP,
            "bkc", MediaType.BACKUP,
            "bkp", MediaType.BACKUP,
            "bks", MediaType.BACKUP,
            "nco", MediaType.BACKUP,
            "qbx", MediaType.BACKUP,
            "skb", MediaType.BACKUP,
            "nrs", MediaType.BACKUP,
            "001", MediaType.BACKUP,
            "jbk", MediaType.BACKUP,
            "oeb", MediaType.BACKUP,
            "qbb", MediaType.BACKUP,
            "rrr", MediaType.BACKUP,
            "bdb", MediaType.BACKUP,
            "rdb", MediaType.BACKUP,
            "win", MediaType.BACKUP,
            "$$$", MediaType.BACKUP,
            "dbk", MediaType.BACKUP,
            "gb1", MediaType.BACKUP,
            "abbu", MediaType.BACKUP,
            "da0", MediaType.BACKUP,
            "rbk", MediaType.BACKUP,
            "rbf", MediaType.BACKUP,
            "113", MediaType.BACKUP,
            "tmp", MediaType.BACKUP,
            "bup", MediaType.BACKUP,
            "bcm", MediaType.BACKUP,
            "bck", MediaType.BACKUP,

            "fb2", MediaType.BOOK,
            "epub", MediaType.BOOK,

            "mpkg", MediaType.COMPRESSED,
            "dist", MediaType.COMPRESSED,
            "c00", MediaType.COMPRESSED,
            "c01", MediaType.COMPRESSED,
            "c02", MediaType.COMPRESSED,
            "qda", MediaType.COMPRESSED,
            "kgb", MediaType.COMPRESSED,
            "enc", MediaType.COMPRESSED,
            "ha", MediaType.COMPRESSED,
            "cpgz", MediaType.COMPRESSED,
            "rk", MediaType.COMPRESSED,
            "lbr", MediaType.COMPRESSED,
            "rar", MediaType.COMPRESSED,
            "pkg", MediaType.COMPRESSED,
            "dd", MediaType.COMPRESSED,
            "tbz2", MediaType.COMPRESSED,
            "ain", MediaType.COMPRESSED,
            "lqr", MediaType.COMPRESSED,
            "gzip", MediaType.COMPRESSED,
            "ice", MediaType.COMPRESSED,
            "wad", MediaType.COMPRESSED,
            "war", MediaType.COMPRESSED,
            "p7m", MediaType.COMPRESSED,
            "sqz", MediaType.COMPRESSED,
            "sqx", MediaType.COMPRESSED,
            "rz", MediaType.COMPRESSED,
            "boo", MediaType.COMPRESSED,
            "ipk", MediaType.COMPRESSED,
            "car", MediaType.COMPRESSED,
            "shk", MediaType.COMPRESSED,
            "xx", MediaType.COMPRESSED,
            "zoo", MediaType.COMPRESSED,
            "axx", MediaType.COMPRESSED,
            "pwa", MediaType.COMPRESSED,
            "par", MediaType.COMPRESSED,
            "pae", MediaType.COMPRESSED,
            "pak", MediaType.COMPRESSED,
            "alz", MediaType.COMPRESSED,
            "r01", MediaType.COMPRESSED,
            "r00", MediaType.COMPRESSED,
            "r03", MediaType.COMPRESSED,
            "r02", MediaType.COMPRESSED,
            "ace", MediaType.COMPRESSED,
            "package", MediaType.COMPRESSED,
            "cbr", MediaType.COMPRESSED,
            "ar", MediaType.COMPRESSED,
            "cbz", MediaType.COMPRESSED,
            "cp9", MediaType.COMPRESSED,
            "hyp", MediaType.COMPRESSED,
            "pbi", MediaType.COMPRESSED,
            "puz", MediaType.COMPRESSED,
            "deb", MediaType.COMPRESSED,
            "ish", MediaType.COMPRESSED,
            "lha", MediaType.COMPRESSED,
            "pcv", MediaType.COMPRESSED,
            "uha", MediaType.COMPRESSED,
            "yz", MediaType.COMPRESSED,
            "lzma", MediaType.COMPRESSED,
            "pup", MediaType.COMPRESSED,
            "par2", MediaType.COMPRESSED,
            "bhx", MediaType.COMPRESSED,
            "7z", MediaType.COMPRESSED,
            "bz2", MediaType.COMPRESSED,
            "efw", MediaType.COMPRESSED,
            "rte", MediaType.COMPRESSED,
            "arc", MediaType.COMPRESSED,
            "sea", MediaType.COMPRESSED,
            "ari", MediaType.COMPRESSED,
            "arj", MediaType.COMPRESSED,
            "wot", MediaType.COMPRESSED,
            "xez", MediaType.COMPRESSED,
            "tgz", MediaType.COMPRESSED,
            "pf", MediaType.COMPRESSED,
            "paq6", MediaType.COMPRESSED,
            "paq7", MediaType.COMPRESSED,
            "paq8", MediaType.COMPRESSED,
            "shar", MediaType.COMPRESSED,
            "mint", MediaType.COMPRESSED,
            "dgc", MediaType.COMPRESSED,
            "y", MediaType.COMPRESSED,
            "ipg", MediaType.COMPRESSED,
            "bh", MediaType.COMPRESSED,
            "bz", MediaType.COMPRESSED,
            "xpi", MediaType.COMPRESSED,
            "sdn", MediaType.COMPRESSED,
            "fdp", MediaType.COMPRESSED,
            "z", MediaType.COMPRESSED,
            "gz", MediaType.COMPRESSED,
            "zz", MediaType.COMPRESSED,
            "zfsendtotarget", MediaType.COMPRESSED,
            "hki", MediaType.COMPRESSED,
            "s00", MediaType.COMPRESSED,
            "s02", MediaType.COMPRESSED,
            "zip", MediaType.COMPRESSED,
            "zix", MediaType.COMPRESSED,
            "tar", MediaType.COMPRESSED,
            "gca", MediaType.COMPRESSED,
            "sit", MediaType.COMPRESSED,
            "lzh", MediaType.COMPRESSED,
            "dar", MediaType.COMPRESSED,
            "ecs", MediaType.COMPRESSED,
            "sfx", MediaType.COMPRESSED,
            "sfs", MediaType.COMPRESSED,
            "tbz", MediaType.COMPRESSED,
            "shr", MediaType.COMPRESSED,
            "tlz", MediaType.COMPRESSED,
            "rpm", MediaType.COMPRESSED,
            "uc2", MediaType.COMPRESSED,
            "lzx", MediaType.COMPRESSED,
            "sitx", MediaType.COMPRESSED,
            "s7z", MediaType.COMPRESSED,
            "xef", MediaType.COMPRESSED,
            "lzo", MediaType.COMPRESSED,
            "hki1", MediaType.COMPRESSED,
            "hki2", MediaType.COMPRESSED,
            "hki3", MediaType.COMPRESSED,
            "vsi", MediaType.COMPRESSED,
            "dmg", MediaType.COMPRESSED,
            "pim", MediaType.COMPRESSED,
            "piz", MediaType.COMPRESSED,
            "pit", MediaType.COMPRESSED,
            "hpk", MediaType.COMPRESSED,
            "s01", MediaType.COMPRESSED,

            "xtp", MediaType.DATA,
            "ebuild", MediaType.DATA,
            "zdb", MediaType.DATA,
            "net", MediaType.DATA,
            "xfo", MediaType.DATA,
            "wdb", MediaType.DATA,
            "txf", MediaType.DATA,
            "qdf", MediaType.DATA,
            "mm", MediaType.DATA,
            "mp", MediaType.DATA,
            "ov2", MediaType.DATA,
            "1ph", MediaType.DATA,
            "ova", MediaType.DATA,
            "opf", MediaType.DATA,
            "ovl", MediaType.DATA,
            "clp", MediaType.DATA,
            "pjx", MediaType.DATA,
            "mdn", MediaType.DATA,
            "mdl", MediaType.DATA,
            "mdb", MediaType.DATA,
            "mdc", MediaType.DATA,
            "mdz", MediaType.DATA,
            "mdt", MediaType.DATA,
            "wgt", MediaType.DATA,
            "isf", MediaType.DATA,
            "a3w", MediaType.DATA,
            "a3m", MediaType.DATA,
            "a3l", MediaType.DATA,
            "flame", MediaType.DATA,
            "lbx", MediaType.DATA,
            "fasta", MediaType.DATA,
            "lp7", MediaType.DATA,
            "db", MediaType.DATA,
            "emd", MediaType.DATA,
            "emb", MediaType.DATA,
            "t04", MediaType.DATA,
            "t03", MediaType.DATA,
            "t01", MediaType.DATA,
            "wtr", MediaType.DATA,
            "gxl", MediaType.DATA,
            "mc9", MediaType.DATA,
            "mc1", MediaType.DATA,
            "fro", MediaType.DATA,
            "frl", MediaType.DATA,
            "gnp", MediaType.DATA,
            "wfm", MediaType.DATA,
            "ib", MediaType.DATA,
            "sav", MediaType.DATA,
            "topc", MediaType.DATA,
            "kid", MediaType.DATA,
            "nmind", MediaType.DATA,
            "jude", MediaType.DATA,
            "opx", MediaType.DATA,
            "lcf", MediaType.DATA,
            "rnq", MediaType.DATA,
            "lcm", MediaType.DATA,
            "brd", MediaType.DATA,
            "fox", MediaType.DATA,
            "ics", MediaType.DATA,
            "mbl", MediaType.DATA,
            "mbg", MediaType.DATA,
            "s85", MediaType.DATA,
            "wab", MediaType.DATA,
            "pp2", MediaType.DATA,
            "mth", MediaType.DATA,
            "qif", MediaType.DATA,
            "np", MediaType.DATA,
            "sqr", MediaType.DATA,
            "sql", MediaType.DATA,
            "fop", MediaType.DATA,
            "sqd", MediaType.DATA,
            "fsc", MediaType.DATA,
            "roi", MediaType.DATA,
            "rog", MediaType.DATA,
            "llb", MediaType.DATA,
            "irock", MediaType.DATA,
            "dii", MediaType.DATA,
            "pmr", MediaType.DATA,
            "pmd", MediaType.DATA,
            "bok", MediaType.DATA,
            "oo3", MediaType.DATA,
            "ulz", MediaType.DATA,
            "flt", MediaType.DATA,
            "cat", MediaType.DATA,
            "tfrd", MediaType.DATA,
            "fll", MediaType.DATA,
            "flo", MediaType.DATA,
            "sps", MediaType.DATA,
            "spo", MediaType.DATA,
            "nyf", MediaType.DATA,
            "mat", MediaType.DATA,
            "mai", MediaType.DATA,
            "sq", MediaType.DATA,
            "fp5", MediaType.DATA,
            "fp4", MediaType.DATA,
            "fp7", MediaType.DATA,
            "fp3", MediaType.DATA,
            "lsu", MediaType.DATA,
            "lsr", MediaType.DATA,
            "shp", MediaType.DATA,
            "tjp", MediaType.DATA,
            "mbx", MediaType.DATA,
            "or4", MediaType.DATA,
            "ev", MediaType.DATA,
            "tkfl", MediaType.DATA,
            "org", MediaType.DATA,
            "fmp", MediaType.DATA,
            "fm5", MediaType.DATA,
            "sar", MediaType.DATA,
            "fcs", MediaType.DATA,
            "^^^", MediaType.DATA,
            "ns2", MediaType.DATA,
            "p96", MediaType.DATA,
            "p97", MediaType.DATA,
            "neta", MediaType.DATA,
            "itw", MediaType.DATA,
            "pot", MediaType.DATA,
            "$er", MediaType.DATA,
            "hdf", MediaType.DATA,
            "hdl", MediaType.DATA,
            "ivt", MediaType.DATA,
            "pab", MediaType.DATA,
            "pan", MediaType.DATA,
            "wpf", MediaType.DATA,
            "gdb", MediaType.DATA,
            "rgo", MediaType.DATA,
            "mmap", MediaType.DATA,
            "psa", MediaType.DATA,
            "grib", MediaType.DATA,
            "pst", MediaType.DATA,
            "a65", MediaType.DATA,
            "ddc", MediaType.DATA,
            "kmz", MediaType.DATA,
            "tdl", MediaType.DATA,
            "vscontent", MediaType.DATA,
            "cbg", MediaType.DATA,
            "igc", MediaType.DATA,
            "mny", MediaType.DATA,
            "ptk", MediaType.DATA,
            "sch", MediaType.DATA,
            "scf", MediaType.DATA,
            "sca", MediaType.DATA,
            "ptb", MediaType.DATA,
            "mnk", MediaType.DATA,
            "mnc", MediaType.DATA,
            "1pe", MediaType.DATA,
            "mpx", MediaType.DATA,
            "ddcx", MediaType.DATA,
            "tef", MediaType.DATA,
            "abi", MediaType.DATA,
            "ab1", MediaType.DATA,
            "ab3", MediaType.DATA,
            "dex", MediaType.DATA,
            "des", MediaType.DATA,
            "a5l", MediaType.DATA,
            "dem", MediaType.DATA,
            "a5w", MediaType.DATA,
            "csa", MediaType.DATA,
            "fp", MediaType.DATA,
            "bkk", MediaType.DATA,
            "fa", MediaType.DATA,
            "fm", MediaType.DATA,
            "fo", MediaType.DATA,
            "itn", MediaType.DATA,
            "itl", MediaType.DATA,
            "ffd", MediaType.DATA,
            "uvf", MediaType.DATA,
            "ftw", MediaType.DATA,
            "mmp", MediaType.DATA,
            "pub", MediaType.DATA,
            "sbf", MediaType.DATA,
            "ask", MediaType.DATA,
            "3dt", MediaType.DATA,
            "dft", MediaType.DATA,
            "a4l", MediaType.DATA,
            "a4m", MediaType.DATA,
            "a4w", MediaType.DATA,
            "gpx", MediaType.DATA,
            "jef", MediaType.DATA,
            "tfd", MediaType.DATA,
            "tfa", MediaType.DATA,
            "sta", MediaType.DATA,
            "stk", MediaType.DATA,
            "qpm", MediaType.DATA,
            "qpb", MediaType.DATA,
            "ccr", MediaType.DATA,
            "lif", MediaType.DATA,
            "lix", MediaType.DATA,
            "qbw", MediaType.DATA,
            "tps", MediaType.DATA,
            "rf1", MediaType.DATA,
            "hif", MediaType.DATA,
            "mfo", MediaType.DATA,
            "seq", MediaType.DATA,
            "pvl", MediaType.DATA,
            "wor", MediaType.DATA,
            "emlxpart", MediaType.DATA,
            "pcap", MediaType.DATA,
            "pdd", MediaType.DATA,
            "pdb", MediaType.DATA,
            "swk", MediaType.DATA,
            "pi", MediaType.DATA,
            "mls", MediaType.DATA,
            "vok", MediaType.DATA,
            "dgb", MediaType.DATA,
            "gst", MediaType.DATA,
            "rge", MediaType.DATA,
            "e00", MediaType.DATA,
            "pex", MediaType.DATA,
            "bk", MediaType.DATA,
            "nsf", MediaType.DATA,
            "chn", MediaType.DATA,
            "sdq", MediaType.DATA,
            "sds", MediaType.DATA,
            "pwd", MediaType.DATA,
            "sdb", MediaType.DATA,
            "ns3", MediaType.DATA,
            "ns4", MediaType.DATA,
            "fdb", MediaType.DATA,
            "sxi", MediaType.DATA,
            "grf", MediaType.DATA,
            "gra", MediaType.DATA,
            "wmdb", MediaType.DATA,
            "otln", MediaType.DATA,
            "edb", MediaType.DATA,
            "gc", MediaType.DATA,
            "pdas", MediaType.DATA,
            "trd", MediaType.DATA,
            "evy", MediaType.DATA,
            "trs", MediaType.DATA,
            "odx", MediaType.DATA,
            "odb", MediaType.DATA,
            "odf", MediaType.DATA,
            "ctt", MediaType.DATA,
            "ctf", MediaType.DATA,
            "chg", MediaType.DATA,
            "pfc", MediaType.DATA,
            "pfl", MediaType.DATA,
            "iif", MediaType.DATA,
            "abcd", MediaType.DATA,
            "aft", MediaType.DATA,
            "gcx", MediaType.DATA,
            "notebook", MediaType.DATA,
            "npt", MediaType.DATA,
            "tsv", MediaType.DATA,
            "tst", MediaType.DATA,
            "daf", MediaType.DATA,
            "dam", MediaType.DATA,
            "dat", MediaType.DATA,
            "das", MediaType.DATA,
            "sdf", MediaType.DATA,
            "kpr", MediaType.DATA,
            "vcf", MediaType.DATA,
            "t02", MediaType.DATA,
            "qdfm", MediaType.DATA,
            "potx", MediaType.DATA,
            "cys", MediaType.DATA,
            "rsw", MediaType.DATA,
            "cyo", MediaType.DATA,
            "ckt", MediaType.DATA,
            "dbc", MediaType.DATA,
            "dbf", MediaType.DATA,
            "dbx", MediaType.DATA,
            "dp1", MediaType.DATA,
            "mgc", MediaType.DATA,
            "spub", MediaType.DATA,
            "123", MediaType.DATA,
            "xdp", MediaType.DATA,
            "db2", MediaType.DATA,
            "shx", MediaType.DATA,
            "btm", MediaType.DATA,
            "dlg", MediaType.DATA,
            "yam", MediaType.DATA,
            "lgh", MediaType.DATA,
            "lgi", MediaType.DATA,
            "wki", MediaType.DATA,
            "wku", MediaType.DATA,
            "wk2", MediaType.DATA,
            "wk5", MediaType.DATA,
            "ofm", MediaType.DATA,
            "mfp", MediaType.DATA,
            "skv", MediaType.DATA,
            "skx", MediaType.DATA,
            "adx", MediaType.DATA,
            "ade", MediaType.DATA,
            "gms", MediaType.DATA,
            "nvl", MediaType.DATA,
            "xsn", MediaType.DATA,
            "kdb", MediaType.DATA,
            "ess", MediaType.DATA,
            "esp", MediaType.DATA,
            "dcl", MediaType.DATA,
            "ndx", MediaType.DATA,
            "postal", MediaType.DATA,
            "val", MediaType.DATA,
            "dm2", MediaType.DATA,
            "rcd", MediaType.DATA,
            "eap", MediaType.DATA,
            "sgml", MediaType.DATA,
            "dmo", MediaType.DATA,
            "inp", MediaType.DATA,
            "ink", MediaType.DATA,
            "voi", MediaType.DATA,
            "oab", MediaType.DATA,
            "mcd", MediaType.DATA,
            "bci", MediaType.DATA,
            "cws", MediaType.DATA,

            "au3", MediaType.DEVELOPMENT,
            "mhtml", MediaType.DEVELOPMENT,
            "ihtml", MediaType.DEVELOPMENT,
            "m4", MediaType.DEVELOPMENT,
            "h", MediaType.DEVELOPMENT,
            "jpd", MediaType.DEVELOPMENT,
            "vpc", MediaType.DEVELOPMENT,
            "md", MediaType.DEVELOPMENT,
            "ml", MediaType.DEVELOPMENT,
            "mk", MediaType.DEVELOPMENT,
            "xht", MediaType.DEVELOPMENT,
            "ent", MediaType.DEVELOPMENT,
            "config", MediaType.DEVELOPMENT,
            "las", MediaType.DEVELOPMENT,
            "vcproj", MediaType.DEVELOPMENT,
            "fic", MediaType.DEVELOPMENT,
            "cls", MediaType.DEVELOPMENT,
            "ru", MediaType.DEVELOPMENT,
            "dsp", MediaType.DEVELOPMENT,
            "rc", MediaType.DEVELOPMENT,
            "iss", MediaType.DEVELOPMENT,
            "isc", MediaType.DEVELOPMENT,
            "rsrc", MediaType.DEVELOPMENT,
            "eql", MediaType.DEVELOPMENT,
            "lbs", MediaType.DEVELOPMENT,
            "bs2", MediaType.DEVELOPMENT,
            "lbi", MediaType.DEVELOPMENT,
            "vgc", MediaType.DEVELOPMENT,
            "sud", MediaType.DEVELOPMENT,
            "dob", MediaType.DEVELOPMENT,
            "m", MediaType.DEVELOPMENT,
            "dox", MediaType.DEVELOPMENT,
            "oca", MediaType.DEVELOPMENT,
            "ocx", MediaType.DEVELOPMENT,
            "sup", MediaType.DEVELOPMENT,
            "bas", MediaType.DEVELOPMENT,
            "omo", MediaType.DEVELOPMENT,
            "cod", MediaType.DEVELOPMENT,
            "frm", MediaType.DEVELOPMENT,
            "frx", MediaType.DEVELOPMENT,
            "dsk", MediaType.DEVELOPMENT,
            "sln", MediaType.DEVELOPMENT,
            "shtml", MediaType.DEVELOPMENT,
            "nib", MediaType.DEVELOPMENT,
            "lasso", MediaType.DEVELOPMENT,
            "pbproj", MediaType.DEVELOPMENT,
            "has", MediaType.DEVELOPMENT,
            "rnc", MediaType.DEVELOPMENT,
            "bpg", MediaType.DEVELOPMENT,
            "bpl", MediaType.DEVELOPMENT,
            "vdm", MediaType.DEVELOPMENT,
            "for", MediaType.DEVELOPMENT,
            "plc", MediaType.DEVELOPMENT,
            "rb", MediaType.DEVELOPMENT,
            "o", MediaType.DEVELOPMENT,
            "kdevdlg", MediaType.DEVELOPMENT,
            "global", MediaType.DEVELOPMENT,
            "aspx", MediaType.DEVELOPMENT,
            "p", MediaType.DEVELOPMENT,
            "htm", MediaType.DEVELOPMENT,
            "targets", MediaType.DEVELOPMENT,
            "bb", MediaType.DEVELOPMENT,
            "$01", MediaType.DEVELOPMENT,
            "spt", MediaType.DEVELOPMENT,
            "fpd", MediaType.DEVELOPMENT,
            "fpa", MediaType.DEVELOPMENT,
            "fpm", MediaType.DEVELOPMENT,
            "fpp", MediaType.DEVELOPMENT,
            "xhtml", MediaType.DEVELOPMENT,
            "csi", MediaType.DEVELOPMENT,
            "mak", MediaType.DEVELOPMENT,
            "sh", MediaType.DEVELOPMENT,
            "so", MediaType.DEVELOPMENT,
            "sc", MediaType.DEVELOPMENT,
            "lsp", MediaType.DEVELOPMENT,
            "jic", MediaType.DEVELOPMENT,
            "fla", MediaType.DEVELOPMENT,
            "ex", MediaType.DEVELOPMENT,
            "phtml", MediaType.DEVELOPMENT,
            "sas", MediaType.DEVELOPMENT,
            "ged", MediaType.DEVELOPMENT,
            "ssc", MediaType.DEVELOPMENT,
            "lnt", MediaType.DEVELOPMENT,
            "js", MediaType.DEVELOPMENT,
            "s", MediaType.DEVELOPMENT,
            "bml", MediaType.DEVELOPMENT,
            "f90", MediaType.DEVELOPMENT,
            "pas", MediaType.DEVELOPMENT,
            "cxx", MediaType.DEVELOPMENT,
            "mod", MediaType.DEVELOPMENT,
            "vdproj", MediaType.DEVELOPMENT,
            "pod", MediaType.DEVELOPMENT,
            "src", MediaType.DEVELOPMENT,
            "kdevprj", MediaType.DEVELOPMENT,
            "gorm", MediaType.DEVELOPMENT,
            "ab", MediaType.DEVELOPMENT,
            "cbl", MediaType.DEVELOPMENT,
            "as", MediaType.DEVELOPMENT,
            "lgo", MediaType.DEVELOPMENT,
            "kdevelop", MediaType.DEVELOPMENT,
            "lassoap", MediaType.DEVELOPMENT,
            "dsw", MediaType.DEVELOPMENT,
            "cpp", MediaType.DEVELOPMENT,
            "ptl", MediaType.DEVELOPMENT,
            "tk", MediaType.DEVELOPMENT,
            "mpr", MediaType.DEVELOPMENT,
            "abc", MediaType.DEVELOPMENT,
            "vic", MediaType.DEVELOPMENT,
            "dev", MediaType.DEVELOPMENT,
            "dec", MediaType.DEVELOPMENT,
            "def", MediaType.DEVELOPMENT,
            "hhh", MediaType.DEVELOPMENT,
            "snippet", MediaType.DEVELOPMENT,
            "cst", MediaType.DEVELOPMENT,
            "a", MediaType.DEVELOPMENT,
            "lhs", MediaType.DEVELOPMENT,
            "pch", MediaType.DEVELOPMENT,
            "html", MediaType.DEVELOPMENT,
            "framework", MediaType.DEVELOPMENT,
            "asm", MediaType.DEVELOPMENT,
            "dylib", MediaType.DEVELOPMENT,
            "php", MediaType.DEVELOPMENT,
            "dfm", MediaType.DEVELOPMENT,
            "jed", MediaType.DEVELOPMENT,
            "stm", MediaType.DEVELOPMENT,
            "df1", MediaType.DEVELOPMENT,
            "qpr", MediaType.DEVELOPMENT,
            "lit", MediaType.DEVELOPMENT,
            "lis", MediaType.DEVELOPMENT,
            "jsp", MediaType.DEVELOPMENT,
            "kb", MediaType.DEVELOPMENT,
            "tpu", MediaType.DEVELOPMENT,
            "tpx", MediaType.DEVELOPMENT,
            "xcode", MediaType.DEVELOPMENT,
            "ymp", MediaType.DEVELOPMENT,
            "dtd", MediaType.DEVELOPMENT,
            "fgl", MediaType.DEVELOPMENT,
            "c", MediaType.DEVELOPMENT,
            "pdm", MediaType.DEVELOPMENT,
            "java", MediaType.DEVELOPMENT,
            "py", MediaType.DEVELOPMENT,
            "pl", MediaType.DEVELOPMENT,
            "pm", MediaType.DEVELOPMENT,
            "jpx", MediaType.DEVELOPMENT,
            "jpr", MediaType.DEVELOPMENT,
            "lds", MediaType.DEVELOPMENT,
            "xcodeproj", MediaType.DEVELOPMENT,
            "d", MediaType.DEVELOPMENT,
            "cgi", MediaType.DEVELOPMENT,
            "s19", MediaType.DEVELOPMENT,
            "rul", MediaType.DEVELOPMENT,
            "ui", MediaType.DEVELOPMENT,
            "agi", MediaType.DEVELOPMENT,
            "cfm", MediaType.DEVELOPMENT,
            "vbg", MediaType.DEVELOPMENT,
            "ctx", MediaType.DEVELOPMENT,
            "vbp", MediaType.DEVELOPMENT,
            "ctl", MediaType.DEVELOPMENT,
            "vbz", MediaType.DEVELOPMENT,
            "vbx", MediaType.DEVELOPMENT,
            "xaml", MediaType.DEVELOPMENT,
            "f", MediaType.DEVELOPMENT,
            "acd", MediaType.DEVELOPMENT,
            "maff", MediaType.DEVELOPMENT,
            "out", MediaType.DEVELOPMENT,
            "vcx", MediaType.DEVELOPMENT,
            "vc4", MediaType.DEVELOPMENT,
            "var", MediaType.DEVELOPMENT,
            "pyd", MediaType.DEVELOPMENT,
            "class", MediaType.DEVELOPMENT,
            "jav", MediaType.DEVELOPMENT,
            "aep", MediaType.DEVELOPMENT,
            "dpr", MediaType.DEVELOPMENT,
            "qx", MediaType.DEVELOPMENT,
            "sha", MediaType.DEVELOPMENT,
            "dpl", MediaType.DEVELOPMENT,
            "dpk", MediaType.DEVELOPMENT,
            "shtm", MediaType.DEVELOPMENT,
            "lua", MediaType.DEVELOPMENT,
            "lproj", MediaType.DEVELOPMENT,
            "cc", MediaType.DEVELOPMENT,
            "cs", MediaType.DEVELOPMENT,
            "cp", MediaType.DEVELOPMENT,
            "fsproj", MediaType.DEVELOPMENT,
            "bbc", MediaType.DEVELOPMENT,
            "yab", MediaType.DEVELOPMENT,
            "rbw", MediaType.DEVELOPMENT,
            "rbp", MediaType.DEVELOPMENT,
            "rbc", MediaType.DEVELOPMENT,
            "i", MediaType.DEVELOPMENT,
            "tcl", MediaType.DEVELOPMENT,
            "gmk", MediaType.DEVELOPMENT,
            "ads", MediaType.DEVELOPMENT,
            "adp", MediaType.DEVELOPMENT,
            "gmd", MediaType.DEVELOPMENT,
            "adb", MediaType.DEVELOPMENT,
            "ada", MediaType.DEVELOPMENT,
            "xsd", MediaType.DEVELOPMENT,
            "mht", MediaType.DEVELOPMENT,
            "gm6", MediaType.DEVELOPMENT,
            "vsm", MediaType.DEVELOPMENT,
            "dcu", MediaType.DEVELOPMENT,
            "dcp", MediaType.DEVELOPMENT,
            "vac", MediaType.DEVELOPMENT,
            "hs", MediaType.DEVELOPMENT,
            "hh", MediaType.DEVELOPMENT,
            "j", MediaType.DEVELOPMENT,
            "inc", MediaType.DEVELOPMENT,
            "hpp", MediaType.DEVELOPMENT,
            "php3", MediaType.DEVELOPMENT,
            "res", MediaType.DEVELOPMENT,
            "bcp", MediaType.DEVELOPMENT,

            "ima", MediaType.DISKIMAGE,
            "img", MediaType.DISKIMAGE,
            "mdf", MediaType.DISKIMAGE,
            "mds", MediaType.DISKIMAGE,
            "smi", MediaType.DISKIMAGE,
            "md0", MediaType.DISKIMAGE,
            "md1", MediaType.DISKIMAGE,
            "isz", MediaType.DISKIMAGE,
            "iso", MediaType.DISKIMAGE,
            "c2d", MediaType.DISKIMAGE,
            "tzx", MediaType.DISKIMAGE,
            "lcd", MediaType.DISKIMAGE,
            "vdi", MediaType.DISKIMAGE,
            "partimg", MediaType.DISKIMAGE,
            "d64", MediaType.DISKIMAGE,
            "tib", MediaType.DISKIMAGE,
            "ibp", MediaType.DISKIMAGE,
            "ibq", MediaType.DISKIMAGE,
            "st", MediaType.DISKIMAGE,
            "xa", MediaType.DISKIMAGE,
            "sqfs", MediaType.DISKIMAGE,
            "gkh", MediaType.DISKIMAGE,
            "fcd", MediaType.DISKIMAGE,
            "xmd", MediaType.DISKIMAGE,
            "xmf", MediaType.DISKIMAGE,
            "fdi", MediaType.DISKIMAGE,
            "lnx", MediaType.DISKIMAGE,
            "ccd", MediaType.DISKIMAGE,
            "b5t", MediaType.DISKIMAGE,
            "b5i", MediaType.DISKIMAGE,
            "td0", MediaType.DISKIMAGE,
            "image", MediaType.DISKIMAGE,
            "vhd", MediaType.DISKIMAGE,
            "aa", MediaType.DISKIMAGE,
            "uif", MediaType.DISKIMAGE,
            "tc", MediaType.DISKIMAGE,
            "cso", MediaType.DISKIMAGE,
            "ncd", MediaType.DISKIMAGE,
            "cdi", MediaType.DISKIMAGE,
            "pdi", MediaType.DISKIMAGE,
            "nrg", MediaType.DISKIMAGE,
            "x64", MediaType.DISKIMAGE,
            "000", MediaType.DISKIMAGE,
            "simg", MediaType.DISKIMAGE,
            "cue", MediaType.DISKIMAGE,
            "ixa", MediaType.DISKIMAGE,
            "cif", MediaType.DISKIMAGE,
            "dvd", MediaType.DISKIMAGE,
            "eda", MediaType.DISKIMAGE,
            "ede", MediaType.DISKIMAGE,
            "edk", MediaType.DISKIMAGE,
            "eds", MediaType.DISKIMAGE,
            "p01", MediaType.DISKIMAGE,
            "edq", MediaType.DISKIMAGE,
            "gi", MediaType.DISKIMAGE,
            "flp", MediaType.DISKIMAGE,
            "pxi", MediaType.DISKIMAGE,
            "tao", MediaType.DISKIMAGE,
            "gcd", MediaType.DISKIMAGE,
            "i02", MediaType.DISKIMAGE,
            "i00", MediaType.DISKIMAGE,
            "i01", MediaType.DISKIMAGE,
            "eui", MediaType.DISKIMAGE,
            "daa", MediaType.DISKIMAGE,
            "dao", MediaType.DISKIMAGE,
            "vcd", MediaType.DISKIMAGE,
            "pqi", MediaType.DISKIMAGE,
            "bws", MediaType.DISKIMAGE,
            "bwt", MediaType.DISKIMAGE,
            "bwa", MediaType.DISKIMAGE,
            "bwi", MediaType.DISKIMAGE,
            "vaporcd", MediaType.DISKIMAGE,
            "dms", MediaType.DISKIMAGE,
            "cd", MediaType.DISKIMAGE,
            "sopt", MediaType.DISKIMAGE,
            "ratdvd", MediaType.DISKIMAGE,
            "edv", MediaType.DISKIMAGE,
            "adz", MediaType.DISKIMAGE,
            "adf", MediaType.DISKIMAGE,
            "t64", MediaType.DISKIMAGE,

            "txt", MediaType.DOCUMENT,
            "lwp", MediaType.DOCUMENT,
            "quox", MediaType.DOCUMENT,
            "uof", MediaType.DOCUMENT,
            "pptx", MediaType.DOCUMENT,
            "doc", MediaType.DOCUMENT,
            "dot", MediaType.DOCUMENT,
            "hwpml", MediaType.DOCUMENT,
            "dotx", MediaType.DOCUMENT,
            "mcw", MediaType.DOCUMENT,
            "pps", MediaType.DOCUMENT,
            "ppt", MediaType.DOCUMENT,
            "ots", MediaType.DOCUMENT,
            "xlk", MediaType.DOCUMENT,
            "xlc", MediaType.DOCUMENT,
            "xlw", MediaType.DOCUMENT,
            "xlt", MediaType.DOCUMENT,
            "xls", MediaType.DOCUMENT,
            "xlr", MediaType.DOCUMENT,
            "xl", MediaType.DOCUMENT,
            "ans", MediaType.DOCUMENT,
            "pages", MediaType.DOCUMENT,
            "xml", MediaType.DOCUMENT,
            "xltm", MediaType.DOCUMENT,
            "pap", MediaType.DOCUMENT,
            "wpt", MediaType.DOCUMENT,
            "wpd", MediaType.DOCUMENT,
            "nb", MediaType.DOCUMENT,
            "xmlper", MediaType.DOCUMENT,
            "acl", MediaType.DOCUMENT,
            "djvu", MediaType.DOCUMENT,
            "uoml", MediaType.DOCUMENT,
            "hwp", MediaType.DOCUMENT,
            "nbp", MediaType.DOCUMENT,
            "tex", MediaType.DOCUMENT,
            "abw", MediaType.DOCUMENT,
            "wrf", MediaType.DOCUMENT,
            "wrd", MediaType.DOCUMENT,
            "wri", MediaType.DOCUMENT,
            "ftx", MediaType.DOCUMENT,
            "ftm", MediaType.DOCUMENT,
            "asc", MediaType.DOCUMENT,
            "stw", MediaType.DOCUMENT,
            "rtf", MediaType.DOCUMENT,
            "xslt", MediaType.DOCUMENT,
            "pdf", MediaType.DOCUMENT,
            "xpj", MediaType.DOCUMENT,
            "xps", MediaType.DOCUMENT,
            "xpt", MediaType.DOCUMENT,
            "sdw", MediaType.DOCUMENT,
            "info", MediaType.DOCUMENT,
            "fdx", MediaType.DOCUMENT,
            "sxw", MediaType.DOCUMENT,
            "pdax", MediaType.DOCUMENT,
            "odp", MediaType.DOCUMENT,
            "ods", MediaType.DOCUMENT,
            "odt", MediaType.DOCUMENT,
            "odm", MediaType.DOCUMENT,
            "afp", MediaType.DOCUMENT,
            "cwk", MediaType.DOCUMENT,
            "aww", MediaType.DOCUMENT,
            "rpt", MediaType.DOCUMENT,
            "ppsx", MediaType.DOCUMENT,
            "xlsx", MediaType.DOCUMENT,
            "xlsm", MediaType.DOCUMENT,
            "xlsb", MediaType.DOCUMENT,
            "ott", MediaType.DOCUMENT,
            "docx", MediaType.DOCUMENT,
            "wks", MediaType.DOCUMENT,
            "xsl", MediaType.DOCUMENT,

            "hqx", MediaType.ENCODED,
            "xxe", MediaType.ENCODED,
            "dim", MediaType.ENCODED,
            "shy", MediaType.ENCODED,
            "mime", MediaType.ENCODED,
            "rzx", MediaType.ENCODED,
            "cpio", MediaType.ENCODED,
            "mme", MediaType.ENCODED,
            "efr", MediaType.ENCODED,
            "efu", MediaType.ENCODED,
            "efl", MediaType.ENCODED,
            "sef", MediaType.ENCODED,
            "uue", MediaType.ENCODED,
            "uud", MediaType.ENCODED,
            "dime", MediaType.ENCODED,
            "bin", MediaType.ENCODED,
            "uu", MediaType.ENCODED,
            "vlt", MediaType.ENCODED,
            "bfa", MediaType.ENCODED,
            "mim", MediaType.ENCODED,
            "dc4", MediaType.ENCODED,

            "bat", MediaType.EXECUTABLE,
            "com", MediaType.EXECUTABLE,
            "elf", MediaType.EXECUTABLE,
            "obj", MediaType.EXECUTABLE,
            "lib", MediaType.EXECUTABLE,
            "coff", MediaType.EXECUTABLE,
            "exe", MediaType.EXECUTABLE,
            "dll", MediaType.EXECUTABLE,

            "swf", MediaType.FLASH,
            "flv", MediaType.FLASH,

            "dfont", MediaType.FONT,
            "gdr", MediaType.FONT,
            "xfn", MediaType.FONT,
            "xft", MediaType.FONT,
            "fnt", MediaType.FONT,
            "fon", MediaType.FONT,
            "ttc", MediaType.FONT,
            "ttf", MediaType.FONT,
            "bmf", MediaType.FONT,
            "abf", MediaType.FONT,
            "lwfn", MediaType.FONT,
            "pcf", MediaType.FONT,
            "acfm", MediaType.FONT,
            "amfm", MediaType.FONT,
            "suit", MediaType.FONT,
            "bdf", MediaType.FONT,
            "chr", MediaType.FONT,
            "pfa", MediaType.FONT,
            "pfb", MediaType.FONT,
            "pfm", MediaType.FONT,
            "afm", MediaType.FONT,
            "mgf", MediaType.FONT,
            "otf", MediaType.FONT,
            "eot", MediaType.FONT,

            "cmx", MediaType.IMAGE,
            "nef", MediaType.IMAGE,
            "glm", MediaType.IMAGE,
            "lws", MediaType.IMAGE,
            "lwo", MediaType.IMAGE,
            "ma", MediaType.IMAGE,
            "mb", MediaType.IMAGE,
            "wmf", MediaType.IMAGE,
            "ccp4", MediaType.IMAGE,
            "jpeg", MediaType.IMAGE,
            "mdx", MediaType.IMAGE,
            "smd", MediaType.IMAGE,
            "md2", MediaType.IMAGE,
            "md3", MediaType.IMAGE,
            "lxo", MediaType.IMAGE,
            "raw", MediaType.IMAGE,
            "ras", MediaType.IMAGE,
            "lbm", MediaType.IMAGE,
            "nitf", MediaType.IMAGE,
            "emf", MediaType.IMAGE,
            "cob", MediaType.IMAGE,
            "rgb", MediaType.IMAGE,
            "nif", MediaType.IMAGE,
            "sldprt", MediaType.IMAGE,
            "eps", MediaType.IMAGE,
            "core3d", MediaType.IMAGE,
            "webp", MediaType.IMAGE,
            "ico", MediaType.IMAGE,
            "gif", MediaType.IMAGE,
            "tif", MediaType.IMAGE,
            "dib", MediaType.IMAGE,
            "u3d", MediaType.IMAGE,
            "icns", MediaType.IMAGE,
            "fbx", MediaType.IMAGE,
            "msp", MediaType.IMAGE,
            "c4d", MediaType.IMAGE,
            "dxf", MediaType.IMAGE,
            "max", MediaType.IMAGE,
            "aoi", MediaType.IMAGE,
            "e2d", MediaType.IMAGE,
            "tiff", MediaType.IMAGE,
            "ppm", MediaType.IMAGE,
            "blp", MediaType.IMAGE,
            "rle", MediaType.IMAGE,
            "xpm", MediaType.IMAGE,
            "mesh", MediaType.IMAGE,
            "pns", MediaType.IMAGE,
            "pnm", MediaType.IMAGE,
            "png", MediaType.IMAGE,
            "prc", MediaType.IMAGE,
            "an8", MediaType.IMAGE,
            "mrc", MediaType.IMAGE,
            "pcx", MediaType.IMAGE,
            "vue", MediaType.IMAGE,
            "pov", MediaType.IMAGE,
            "v2d", MediaType.IMAGE,
            "psb", MediaType.IMAGE,
            "psd", MediaType.IMAGE,
            "amf", MediaType.IMAGE,
            "psp", MediaType.IMAGE,
            "exif", MediaType.IMAGE,
            "dds", MediaType.IMAGE,
            "x3d", MediaType.IMAGE,
            "svg", MediaType.IMAGE,
            "ac", MediaType.IMAGE,
            "ai", MediaType.IMAGE,
            "bmp", MediaType.IMAGE,
            "cpt", MediaType.IMAGE,
            "sct", MediaType.IMAGE,
            "mng", MediaType.IMAGE,
            "pbm", MediaType.IMAGE,
            "sldasm", MediaType.IMAGE,
            "pict, pct", MediaType.IMAGE,
            "egt", MediaType.IMAGE,
            "egg", MediaType.IMAGE,
            "rwx", MediaType.IMAGE,
            "pc2", MediaType.IMAGE,
            "pc3", MediaType.IMAGE,
            "pc1", MediaType.IMAGE,
            "iff", MediaType.IMAGE,
            "b3d", MediaType.IMAGE,
            "ase", MediaType.IMAGE,
            "3dv", MediaType.IMAGE,
            "3ds", MediaType.IMAGE,
            "3dm", MediaType.IMAGE,
            "gpl", MediaType.IMAGE,
            "dff", MediaType.IMAGE,
            "3dmf", MediaType.IMAGE,
            "blend", MediaType.IMAGE,
            "cdr", MediaType.IMAGE,
            "cr2", MediaType.IMAGE,
            "x", MediaType.IMAGE,
            "art", MediaType.IMAGE,
            "arw", MediaType.IMAGE,
            "dts", MediaType.IMAGE,
            "skp", MediaType.IMAGE,
            "pdn", MediaType.IMAGE,
            "tga", MediaType.IMAGE,
            "px", MediaType.IMAGE,
            "jpg", MediaType.IMAGE,
            "jps", MediaType.IMAGE,
            "ctm", MediaType.IMAGE,
            "jp2", MediaType.IMAGE,
            "cut", MediaType.IMAGE,
            "pxr", MediaType.IMAGE,
            "wings", MediaType.IMAGE,
            "miff", MediaType.IMAGE,
            "cgm", MediaType.IMAGE,
            "bw", MediaType.IMAGE,
            "block", MediaType.IMAGE,
            "cit", MediaType.IMAGE,
            "sxd", MediaType.IMAGE,
            "xbm", MediaType.IMAGE,
            "cfl", MediaType.IMAGE,
            "odg", MediaType.IMAGE,
            "sgi", MediaType.IMAGE,
            "heif", MediaType.IMAGE,
            "heic", MediaType.IMAGE,
            "xcf", MediaType.IMAGE,
            "sib", MediaType.IMAGE,
            "sia", MediaType.IMAGE,
            "jng", MediaType.IMAGE,
            "dae", MediaType.IMAGE,
            "pgm", MediaType.IMAGE,
            "mm3d", MediaType.IMAGE,
            "z3d", MediaType.IMAGE,
            "awg", MediaType.IMAGE,
            "fact", MediaType.IMAGE,
            "psd, pdd", MediaType.IMAGE,
            "dpm", MediaType.IMAGE,
            "qfx", MediaType.IMAGE,
            "ota", MediaType.IMAGE,
            "off", MediaType.IMAGE,
            "cal3d", MediaType.IMAGE,
            "xar", MediaType.IMAGE,
            "int", MediaType.IMAGE,
            "pi1", MediaType.IMAGE,
            "pi2", MediaType.IMAGE,
            "pi3", MediaType.IMAGE,

            "cwf", MediaType.SETTINGS,
            "drm", MediaType.SETTINGS,
            "vph", MediaType.SETTINGS,
            "plist", MediaType.SETTINGS,
            "env", MediaType.SETTINGS,
            "atf", MediaType.SETTINGS,
            "isp", MediaType.SETTINGS,
            "eqp", MediaType.SETTINGS,
            "conf", MediaType.SETTINGS,
            "ops", MediaType.SETTINGS,
            "icc", MediaType.SETTINGS,
            "ica", MediaType.SETTINGS,
            "cnf", MediaType.SETTINGS,
            "properties", MediaType.SETTINGS,
            "vmtm", MediaType.SETTINGS,
            "sol", MediaType.SETTINGS,
            "ahl", MediaType.SETTINGS,
            "ahs", MediaType.SETTINGS,
            "gid", MediaType.SETTINGS,
            "xwk", MediaType.SETTINGS,
            "mtf", MediaType.SETTINGS,
            "icm", MediaType.SETTINGS,
            "pmc", MediaType.SETTINGS,
            "pref", MediaType.SETTINGS,
            "msm", MediaType.SETTINGS,
            "msi", MediaType.SETTINGS,
            "msf", MediaType.SETTINGS,
            "kyb", MediaType.SETTINGS,
            "kys", MediaType.SETTINGS,
            "sl", MediaType.SETTINGS,
            "xlb", MediaType.SETTINGS,
            "zap", MediaType.SETTINGS,
            "fmt", MediaType.SETTINGS,
            "prf", MediaType.SETTINGS,
            "zon", MediaType.SETTINGS,
            "fcc", MediaType.SETTINGS,
            "wpp", MediaType.SETTINGS,
            "psf", MediaType.SETTINGS,
            "srs", MediaType.SETTINGS,
            "lop", MediaType.SETTINGS,
            "ptf", MediaType.SETTINGS,
            "wmz", MediaType.SETTINGS,
            "wms", MediaType.SETTINGS,
            "atn", MediaType.SETTINGS,
            "csf", MediaType.SETTINGS,
            "asl", MediaType.SETTINGS,
            "downloadhost", MediaType.SETTINGS,
            "lic", MediaType.SETTINGS,
            "exp", MediaType.SETTINGS,
            "hid", MediaType.SETTINGS,
            "xet", MediaType.SETTINGS,
            "xev", MediaType.SETTINGS,
            "pvs", MediaType.SETTINGS,
            "set", MediaType.SETTINGS,
            "mailhost", MediaType.SETTINGS,
            "ph", MediaType.SETTINGS,
            "mlk", MediaType.SETTINGS,
            "rdf", MediaType.SETTINGS,
            "ams", MediaType.SETTINGS,
            "profimail", MediaType.SETTINGS,
            "pen", MediaType.SETTINGS,
            "idf", MediaType.SETTINGS,
            "mskn", MediaType.SETTINGS,
            "cfg", MediaType.SETTINGS,
            "rdp", MediaType.SETTINGS,
            "rdo", MediaType.SETTINGS,
            "vmx", MediaType.SETTINGS,
            "tsk", MediaType.SETTINGS,
            "m2s", MediaType.SETTINGS,
            "reg", MediaType.SETTINGS,
            "ds_store", MediaType.SETTINGS,
            "sfo", MediaType.SETTINGS,
            "dbg", MediaType.SETTINGS,
            "mgm", MediaType.SETTINGS,
            "bcmx", MediaType.SETTINGS,
            "key", MediaType.SETTINGS,
            "cm", MediaType.SETTINGS,
            "xem", MediaType.SETTINGS,
            "xep", MediaType.SETTINGS,
            "xes", MediaType.SETTINGS,
            "ski", MediaType.SETTINGS,
            "nvc", MediaType.SETTINGS,
            "vsw", MediaType.SETTINGS,
            "ini", MediaType.SETTINGS,
            "inf", MediaType.SETTINGS,

            "slk", MediaType.SPREADSHEET,
            "clf", MediaType.SPREADSHEET,
            "gnumeric", MediaType.SPREADSHEET,
            "wq1", MediaType.SPREADSHEET,
            "numbers", MediaType.SPREADSHEET,
            "csv", MediaType.SPREADSHEET,
            "stc", MediaType.SPREADSHEET,
            "qpw", MediaType.SPREADSHEET,
            "sdc", MediaType.SPREADSHEET,
            "sxc", MediaType.SPREADSHEET,
            "cell", MediaType.SPREADSHEET,
            "tab", MediaType.SPREADSHEET,
            "aws", MediaType.SPREADSHEET,
            "vc", MediaType.SPREADSHEET,
            "wk1", MediaType.SPREADSHEET,
            "wk3", MediaType.SPREADSHEET,
            "wk4", MediaType.SPREADSHEET,

            "safetext", MediaType.TEXT,
            "mnt", MediaType.TEXT,
            "upd", MediaType.TEXT,
            "bean", MediaType.TEXT,
            "dne", MediaType.TEXT,
            "err", MediaType.TEXT,
            "mw", MediaType.TEXT,
            "pjt", MediaType.TEXT,
            "rt", MediaType.TEXT,
            "sms", MediaType.TEXT,
            "aty", MediaType.TEXT,
            "nzb", MediaType.TEXT,
            "lbt", MediaType.TEXT,
            "lp2", MediaType.TEXT,
            "mellel", MediaType.TEXT,
            "cyi", MediaType.TEXT,
            "ocr", MediaType.TEXT,
            "dx", MediaType.TEXT,
            "wn", MediaType.TEXT,
            "wp", MediaType.TEXT,
            "unx", MediaType.TEXT,
            "kwd", MediaType.TEXT,
            "sam", MediaType.TEXT,
            "frt", MediaType.TEXT,
            "dotm", MediaType.TEXT,
            "sls", MediaType.TEXT,
            "rng", MediaType.TEXT,
            "epp", MediaType.TEXT,
            "thp", MediaType.TEXT,
            "unauth", MediaType.TEXT,
            "xyw", MediaType.TEXT,
            "gio", MediaType.TEXT,
            "xy3", MediaType.TEXT,
            "xwp", MediaType.TEXT,
            "p7s", MediaType.TEXT,
            "applescript", MediaType.TEXT,
            "diz", MediaType.TEXT,
            "mell", MediaType.TEXT,
            "boc", MediaType.TEXT,
            "1st", MediaType.TEXT,
            "fbl", MediaType.TEXT,
            "msg", MediaType.TEXT,
            "charset", MediaType.TEXT,
            "fpt", MediaType.TEXT,
            "map", MediaType.TEXT,
            "man", MediaType.TEXT,
            "xyp", MediaType.TEXT,
            "lst", MediaType.TEXT,
            "jis", MediaType.TEXT,
            "now", MediaType.TEXT,
            "xlf", MediaType.TEXT,
            "xy", MediaType.TEXT,
            "rzk", MediaType.TEXT,
            "saf", MediaType.TEXT,
            "prt", MediaType.TEXT,
            "wcf", MediaType.TEXT,
            "latex", MediaType.TEXT,
            "luf", MediaType.TEXT,
            "ssa", MediaType.TEXT,
            "wp4", MediaType.TEXT,
            "wp5", MediaType.TEXT,
            "wp6", MediaType.TEXT,
            "wp7", MediaType.TEXT,
            "ascii", MediaType.TEXT,
            "utf8", MediaType.TEXT,
            "wps", MediaType.TEXT,
            "wpl", MediaType.TEXT,
            "wpa", MediaType.TEXT,
            "psw", MediaType.TEXT,
            "wbk", MediaType.TEXT,
            "kml", MediaType.TEXT,
            "srt", MediaType.TEXT,
            "act", MediaType.TEXT,
            "log", MediaType.TEXT,
            "strings", MediaType.TEXT,
            "scm", MediaType.TEXT,
            "scc", MediaType.TEXT,
            "scw", MediaType.TEXT,
            "faq", MediaType.TEXT,
            "wsc", MediaType.TEXT,
            "wsh", MediaType.TEXT,
            "sub", MediaType.TEXT,
            "klg", MediaType.TEXT,
            "gpn", MediaType.TEXT,
            "kon", MediaType.TEXT,
            "oft", MediaType.TEXT,
            "vnt", MediaType.TEXT,
            "tpc", MediaType.TEXT,
            "rtd", MediaType.TEXT,
            "rtx", MediaType.TEXT,
            "yml", MediaType.TEXT,
            "crd", MediaType.TEXT,
            "readme", MediaType.TEXT,
            "rad", MediaType.TEXT,
            "mbox", MediaType.TEXT,
            "dgs", MediaType.TEXT,
            "jp1", MediaType.TEXT,
            "knt", MediaType.TEXT,
            "scpt", MediaType.TEXT,
            "chord", MediaType.TEXT,
            "ipf", MediaType.TEXT,
            "bib", MediaType.TEXT,
            "utxt", MediaType.TEXT,
            "idx", MediaType.TEXT,
            "sdm", MediaType.TEXT,
            "pwi", MediaType.TEXT,
            "fdf", MediaType.TEXT,
            "fds", MediaType.TEXT,
            "fdr", MediaType.TEXT,
            "lyt", MediaType.TEXT,
            "lyx", MediaType.TEXT,
            "dvi", MediaType.TEXT,
            "iil", MediaType.TEXT,
            "sgm", MediaType.TEXT,
            "fes", MediaType.TEXT,
            "pfx", MediaType.TEXT,
            "sig", MediaType.TEXT,
            "euc", MediaType.TEXT,
            "nfo", MediaType.TEXT,
            "vct", MediaType.TEXT,
            "ltr", MediaType.TEXT,
            "ybk", MediaType.TEXT,
            "fxc", MediaType.TEXT,
            "emlx", MediaType.TEXT,
            "indt", MediaType.TEXT,
            "text", MediaType.TEXT,
            "dbt", MediaType.TEXT,
            "imapmbox", MediaType.TEXT,
            "xdl", MediaType.TEXT,
            "rtfd", MediaType.TEXT,
            "email", MediaType.TEXT,
            "etx", MediaType.TEXT,
            "tlb", MediaType.TEXT,
            "etf", MediaType.TEXT,
            "bbs", MediaType.TEXT,
            "opml", MediaType.TEXT,
            "tmx", MediaType.TEXT,
            "dct", MediaType.TEXT,
            "hz", MediaType.TEXT,

            "amv", MediaType.VIDEO,
            "mpeg", MediaType.VIDEO,
            "camrec", MediaType.VIDEO,
            "vp7", MediaType.VIDEO,
            "vp6", MediaType.VIDEO,
            "ts", MediaType.VIDEO,
            "viewlet", MediaType.VIDEO,
            "sfvidcap", MediaType.VIDEO,
            "vfw", MediaType.VIDEO,
            "mxf", MediaType.VIDEO,
            "ajp", MediaType.VIDEO,
            "smv", MediaType.VIDEO,
            "mvb", MediaType.VIDEO,
            "mvc", MediaType.VIDEO,
            "dvr-ms", MediaType.VIDEO,
            "mp21", MediaType.VIDEO,
            "dv", MediaType.VIDEO,
            "nut", MediaType.VIDEO,
            "wm", MediaType.VIDEO,
            "imovieproject", MediaType.VIDEO,
            "vdo", MediaType.VIDEO,
            "webm", MediaType.VIDEO,
            "qtch", MediaType.VIDEO,
            "mts", MediaType.VIDEO,
            "3gpp", MediaType.VIDEO,
            "3gp2", MediaType.VIDEO,
            "veg", MediaType.VIDEO,
            "dif", MediaType.VIDEO,
            "dir", MediaType.VIDEO,
            "box", MediaType.VIDEO,
            "msh", MediaType.VIDEO,
            "wvx", MediaType.VIDEO,
            "flx", MediaType.VIDEO,
            "fli", MediaType.VIDEO,
            "flc", MediaType.VIDEO,
            "dxr", MediaType.VIDEO,
            "spl", MediaType.VIDEO,
            "divx", MediaType.VIDEO,
            "lsf", MediaType.VIDEO,
            "lsx", MediaType.VIDEO,
            "qt", MediaType.VIDEO,
            "yuv", MediaType.VIDEO,
            "pro", MediaType.VIDEO,
            "mpv2", MediaType.VIDEO,
            "prx", MediaType.VIDEO,
            "wcp", MediaType.VIDEO,
            "fcp", MediaType.VIDEO,
            "ssm", MediaType.VIDEO,
            "vivo", MediaType.VIDEO,
            "ivf", MediaType.VIDEO,
            "ivs", MediaType.VIDEO,
            "mov", MediaType.VIDEO,
            "gvi", MediaType.VIDEO,
            "moov", MediaType.VIDEO,
            "gvp", MediaType.VIDEO,
            "grasp", MediaType.VIDEO,
            "d2v", MediaType.VIDEO,
            "60d", MediaType.VIDEO,
            "mp4", MediaType.VIDEO,
            "wmx", MediaType.VIDEO,
            "wmv", MediaType.VIDEO,
            "wmd", MediaType.VIDEO,
            "mpg", MediaType.VIDEO,
            "mpe", MediaType.VIDEO,
            "rm", MediaType.VIDEO,
            "m2ts", MediaType.VIDEO,
            "vid", MediaType.VIDEO,
            "viv", MediaType.VIDEO,
            "eye", MediaType.VIDEO,
            "mqv", MediaType.VIDEO,
            "tda3mt", MediaType.VIDEO,
            "ifo", MediaType.VIDEO,
            "imovieproj", MediaType.VIDEO,
            "izz", MediaType.VIDEO,
            "asx", MediaType.VIDEO,
            "asf", MediaType.VIDEO,
            "sbk", MediaType.VIDEO,
            "tivo", MediaType.VIDEO,
            "str", MediaType.VIDEO,
            "pds", MediaType.VIDEO,
            "swi", MediaType.VIDEO,
            "rmvb", MediaType.VIDEO,
            "vob", MediaType.VIDEO,
            "3g2", MediaType.VIDEO,
            "3gp", MediaType.VIDEO,
            "m4v", MediaType.VIDEO,
            "m4u", MediaType.VIDEO,
            "m4e", MediaType.VIDEO,
            "bik", MediaType.VIDEO,
            "bix", MediaType.VIDEO,
            "nsv", MediaType.VIDEO,
            "mkv", MediaType.VIDEO,
            "svi", MediaType.VIDEO,
            "mswmm", MediaType.VIDEO,
            "izzy", MediaType.VIDEO,
            "gl", MediaType.VIDEO,
            "rts", MediaType.VIDEO,
            "prproj", MediaType.VIDEO,
            "mjp", MediaType.VIDEO,
            "byu", MediaType.VIDEO,
            "m2v", MediaType.VIDEO,
            "m21", MediaType.VIDEO,
            "playlist", MediaType.VIDEO,
            "ogm", MediaType.VIDEO,
            "movie", MediaType.VIDEO,
            "dpg", MediaType.VIDEO,
            "qtz", MediaType.VIDEO,
            "vro", MediaType.VIDEO,
            "m1v", MediaType.VIDEO,
            "cvc", MediaType.VIDEO,
            "vf", MediaType.VIDEO,
            "avs", MediaType.VIDEO,
            "avi", MediaType.VIDEO,
            "avb", MediaType.VIDEO,
            "piv", MediaType.VIDEO,
            "dce", MediaType.VIDEO,
            "smil", MediaType.VIDEO,
            "dmb", MediaType.VIDEO,
            "3mm", MediaType.VIDEO,
            "w32", MediaType.VIDEO,

            "cms", MediaType.WEB,
            "webarchive", MediaType.WEB,
            "wdgt", MediaType.WEB,
            "disco", MediaType.WEB,
            "con", MediaType.WEB,
            "gne", MediaType.WEB,
            "ognc", MediaType.WEB,
            "iqy", MediaType.WEB,
            "url", MediaType.WEB,
            "vrml", MediaType.WEB,
            "jvs", MediaType.WEB,
            "htx", MediaType.WEB,
            "atom", MediaType.WEB,
            "phtm", MediaType.WEB,
            "jhtml", MediaType.WEB,
            "dhtml", MediaType.WEB,
            "jws", MediaType.WEB,
            "jnlp", MediaType.WEB,
            "hxs", MediaType.WEB,
            "moz", MediaType.WEB,
            "qrm", MediaType.WEB,
            "rhtml", MediaType.WEB,
            "rjs", MediaType.WEB,
            "ap", MediaType.WEB,
            "wml", MediaType.WEB,
            "xul", MediaType.WEB,
            "site", MediaType.WEB,
            "discomap", MediaType.WEB,
            "csp", MediaType.WEB,
            "css", MediaType.WEB,
            "rwp", MediaType.WEB,
            "cer", MediaType.WEB,
            "asp", MediaType.WEB,
            "asa", MediaType.WEB,
            "vsdisco", MediaType.WEB,
            "stl", MediaType.WEB,
            "ascx", MediaType.WEB,
            "cdf", MediaType.WEB,
            "crt", MediaType.WEB,
            "pem", MediaType.WEB,
            "cha", MediaType.WEB,
            "wsdl", MediaType.WEB,
            "idc", MediaType.WEB,
            "xpd", MediaType.WEB,
            "chat", MediaType.WEB,
            "jcz", MediaType.WEB,
            "svr", MediaType.WEB,
            "download", MediaType.WEB,
            "hdml", MediaType.WEB,
            "chm", MediaType.WEB,
            "do", MediaType.WEB,
            "dwt", MediaType.WEB,
            "asmx", MediaType.WEB,
            "p12", MediaType.WEB,
            "ece", MediaType.WEB,
            "rss", MediaType.WEB,
            "htaccess", MediaType.WEB,
            "zfo", MediaType.WEB,
            "dbm", MediaType.WEB,
            "sht", MediaType.WEB,
            "oth", MediaType.WEB,
            "htz4", MediaType.WEB,
            "webloc", MediaType.WEB,
            "adr", MediaType.WEB,
            "jspx", MediaType.WEB,
            "zvz", MediaType.WEB,
            "php4", MediaType.WEB,
            "php5", MediaType.WEB
    ).toMap();
}
