package ru.yandex.chemodan.app.djfs.core;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.misc.enums.EnumResolver;

/**
 * @author eoshch
 */
public class StringArrayEnumResolver<T extends Enum<T> & StringArrayEnum> extends EnumResolver<T> {
    private final MapF<String, T> valueToEnum;

    public StringArrayEnumResolver(Class<T> enumClass) {
        super(enumClass);

        valueToEnum = Cf.x(enumClass.getEnumConstants())
                .flatMap(x -> x.representations().map(y -> Tuple2.tuple(y, x)))
                .toMap(x -> x);
    }

    @Override
    public Option<T> valueOfO(String value) {
        return valueToEnum.getO(value);
    }

    public static <T extends Enum<T> & StringArrayEnum> StringArrayEnumResolver<T> r(Class<T> enumClass) {
        return new StringArrayEnumResolver<>(enumClass);
    }
}
