package ru.yandex.chemodan.app.djfs.core;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.enums.EnumResolver;

public class StringIntCombinedEnumResolver<T extends Enum<T> & StringIntCombinedEnum> extends EnumResolver<T> {
    private final MapF<String, T> stringToEnum;
    private final MapF<Integer, T> intToEnum;

    private StringIntCombinedEnumResolver(Class<T> enumClass) {
        super(enumClass);
        stringToEnum = Cf.x(enumClass.getEnumConstants()).toMapMappingToKey(x -> x.getStringRepresentation());
        intToEnum = Cf.x(enumClass.getEnumConstants()).toMapMappingToKey(x -> x.getIntRepresentation());
    }

    @Override
    public Option<T> valueOfO(String value) {
        return stringToEnum.getO(value);
    }

    public Option<T> valueOfO(int value) {
        return intToEnum.getO(value);
    }

    public T valueOf(int value) {
        return intToEnum.getO(value).getOrThrow(
                () -> new IllegalArgumentException("unknown int value of enum " + enumClass.getName() + ": " + value));
    }

    public static <T extends Enum<T> & StringIntCombinedEnum> StringIntCombinedEnumResolver<T> r(Class<T> enumClass) {
        return new StringIntCombinedEnumResolver<>(enumClass);
    }
}
