package ru.yandex.chemodan.app.djfs.core.album;

import lombok.Builder;
import lombok.Value;
import org.bson.types.ObjectId;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.DjfsUidSource;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author eoshch
 */
@Builder(toBuilder = true)
@Value
public class Album implements DjfsUidSource {
    ObjectId id;
    DjfsUid uid;
    String title;
    Option<ObjectId> coverId;  // id field from AlbumItem
    Option<Double> coverOffsetY;
    Option<String> description;

    Option<Instant> dateCreated;
    Option<Instant> dateModified;

    Option<String> publicKey;
    Option<String> publicUrl;
    Option<String> shortUrl;

    boolean isPublic;
    boolean isBlocked;

    Option<String> blockReason;
    Option<ListF<String>> flags;
    Option<AlbumLayoutType> layout;

    Option<String> socialCoverStid;
    Option<Long> fotkiAlbumId;

    Option<Long> revision;

    boolean hidden;
    Option<Long> geoId;

    AlbumType type;

    Option<Boolean> isDescSorting;
    Option<String> albumItemsSorting;
    Option<Boolean> coverAuto;

    public Album withRevision(long revision) {
        return new Album(this.id, this.uid, this.title, this.coverId, this.coverOffsetY, this.description, this.dateCreated,
                this.dateModified, this.publicKey, this.publicUrl, this.shortUrl, this.isPublic, this.isBlocked, this.blockReason,
                this.flags, this.layout, this.socialCoverStid, this.fotkiAlbumId, Option.of(revision), this.hidden, this.geoId, this.type,
                this.isDescSorting, this.albumItemsSorting, this.coverAuto);
    }

    public boolean isCoverAuto() {
        return coverAuto.getOrElse(type == AlbumType.FACES);
    }
}
