package ru.yandex.chemodan.app.djfs.core.album;

import lombok.Getter;

import ru.yandex.chemodan.bazinga.YcridOnetimeTaskSupport;
import ru.yandex.chemodan.bazinga.YcridTaskParameters;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public abstract class AlbumBaseProcessingTask extends YcridOnetimeTaskSupport<AlbumBaseProcessingTask.Parameters> {

    public AlbumBaseProcessingTask() {
        super(Parameters.class);
    }

    public AlbumBaseProcessingTask(String uid, String resourceId) {
        super(new AlbumBaseProcessingTask.Parameters(uid, resourceId));
    }

    @Override
    public abstract void doExecute(Parameters parameters, ExecutionContext context);

    @BenderBindAllFields
    @Getter
    public static class Parameters extends YcridTaskParameters {
        private final String uid;
        private final String resourceId;

        Parameters(String uid, String resourceId) {
            this.uid = uid;
            this.resourceId = resourceId;
        }

        public static Parameters getParameters(String uid, String resourceId) {
            return new Parameters(uid, resourceId);
        }
    }

}
