package ru.yandex.chemodan.app.djfs.core.album;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

import ru.yandex.chemodan.app.djfs.core.client.DataApiHttpClient;
import ru.yandex.chemodan.app.djfs.core.client.DiskSearchHttpClient;
import ru.yandex.chemodan.app.djfs.core.db.DaoProxyFactory;
import ru.yandex.chemodan.app.djfs.core.db.DjfsDbContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.db.mongo.MongoShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.db.pg.TransactionUtils;
import ru.yandex.chemodan.app.djfs.core.diskinfo.DiskInfoManager;
import ru.yandex.chemodan.app.djfs.core.filesystem.DjfsResourceDao;
import ru.yandex.chemodan.app.djfs.core.filesystem.Filesystem;
import ru.yandex.chemodan.app.djfs.core.filesystem.FilesystemContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.history.EventHistoryLogger;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.ResourcePojoBuilder;
import ru.yandex.chemodan.app.djfs.core.notification.NotificationContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.notification.XivaPushGenerator;
import ru.yandex.chemodan.app.djfs.core.operations.OperationDao;
import ru.yandex.chemodan.app.djfs.core.publication.PublicationManager;
import ru.yandex.chemodan.app.djfs.core.share.ShareInfoManager;
import ru.yandex.chemodan.app.djfs.core.user.ClientInputDataProcessor;
import ru.yandex.chemodan.app.djfs.core.user.UserDao;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.inside.geobase.Geobase;
import ru.yandex.inside.geobase.Geobase6;
import ru.yandex.inside.passport.blackbox2.Blackbox2;
import ru.yandex.misc.io.file.File2;

/**
 * @author eoshch
 */
@Configuration
@Import({
        DjfsDbContextConfiguration.class,
        FilesystemContextConfiguration.class,
        NotificationContextConfiguration.class,
})
public class AlbumContextConfiguration {
    @Bean
    public MongoAlbumDao mongoAlbumDao(MongoShardedDaoContext dependencies) {
        return new MongoAlbumDao(dependencies);
    }

    @Bean
    public PgAlbumDao pgAlbumDao(PgShardedDaoContext dependencies) {
        return new PgAlbumDao(dependencies);
    }

    @Bean
    @Primary
    public AlbumDao albumDaoProxy(DaoProxyFactory daoProxyFactory, MongoAlbumDao mongoDao,
            PgAlbumDao pgDao)
    {
        return daoProxyFactory.create(AlbumDao.class, pgDao);
    }

    @Bean
    public PgAlbumFaceClustersDao pgAlbumFaceClustersDao(PgShardedDaoContext dependencies) {
        return new PgAlbumFaceClustersDao(dependencies);
    }

    @Bean
    public MongoAlbumItemDao mongoAlbumItemDao(MongoShardedDaoContext dependencies) {
        return new MongoAlbumItemDao(dependencies);
    }

    @Bean
    public PgAlbumItemDao pgAlbumItemDao(PgShardedDaoContext dependencies) {
        return new PgAlbumItemDao(dependencies);
    }

    @Bean
    @Primary
    public AlbumItemDao albumItemDaoProxy(DaoProxyFactory daoProxyFactory, MongoAlbumItemDao mongoDao,
            PgAlbumItemDao pgDao)
    {
        return daoProxyFactory.create(AlbumItemDao.class, pgDao);
    }

    @Bean
    public PgAlbumDeltaDao pgAlbumDeltaDao(PgShardedDaoContext dependencies) {
        return new PgAlbumDeltaDao(dependencies);
    }

    @Bean
    @Primary
    public AlbumDeltaDao albumAlbumDeltaDaoProxy(DaoProxyFactory daoProxyFactory, PgAlbumDeltaDao pgDao)
    {
        return daoProxyFactory.create(AlbumDeltaDao.class, pgDao);
    }

    @Bean
    public GeoAlbumGenerationProperties geoAlbumGenerationProperties() {
        return new GeoAlbumGenerationProperties();
    }

    @Bean
    public AlbumActions albumActions(UserDao userDao, AlbumDao albumDao, AlbumItemDao albumItemDao, AlbumDeltaDao albumDeltaDao,
                                     GeoAlbumManager geoAlbumManager, PersonalAlbumManager personalAlbumManager, FacesAlbumManager facesAlbumManager, Filesystem filesystem,
                                     FavoritesAlbumManager favoritesAlbumManager, BazingaTaskManager bazingaTaskManager, GeoAlbumGenerationProperties geoAlbumGenerationProperties,
                                     ShareInfoManager shareInfoManager, ClientInputDataProcessor clientInputDataProcessor, EventHistoryLogger eventHistoryLogger,
                                     PublicationManager publicationManager, ResourcePojoBuilder resourcePojoBuilder, DjfsResourceDao djfsResourceDao,
                                     AlbumMergeManager albumMergeManager, MpfsClient mpfsClient)
    {
        return new AlbumActions(userDao, albumDao, albumItemDao, albumDeltaDao, geoAlbumManager, personalAlbumManager, facesAlbumManager, favoritesAlbumManager, filesystem,
                bazingaTaskManager, geoAlbumGenerationProperties, shareInfoManager, clientInputDataProcessor, eventHistoryLogger, publicationManager,
                resourcePojoBuilder, djfsResourceDao, albumMergeManager, mpfsClient);
    }

    @Bean
    public Geobase geobase(
            @Value("${geobase.binary.path:-/var/cache/geobase/geodata6.bin}")
                    String geodataBinary,
            @Value("${geobase.enabled:-false}")
                    boolean geobaseEnabled)
    {
        if (!geobaseEnabled || !new File2(geodataBinary).exists()) {
            return null;
        }
        return new Geobase6(geodataBinary);
    }

    @Bean
    public GeoStrategyProvider geoStrategyProvider(Geobase geobase, DataApiHttpClient dataApiHttpClient) {
        return new GeoStrategyProvider(geobase, dataApiHttpClient);
    }

    @Bean
    public GeoAlbumManager geoAlbumManager(Geobase geobase, AlbumDao albumDao, AlbumDeltaDao albumDeltaDao,
            TransactionUtils transactionUtils, AlbumItemDao albumItemDao, XivaPushGenerator xivaPushGenerator,
            DjfsResourceDao djfsResourceDao, UserDao userDao,
            DiskInfoManager diskInfoManager, GeoStrategyProvider geoStrategyProvider,
            BazingaTaskManager bazingaTaskManager,
            ShareInfoManager shareInfoManager)
    {
        return new GeoAlbumManager(albumDao, albumItemDao, geobase, albumDeltaDao, transactionUtils,  xivaPushGenerator,
                djfsResourceDao, userDao, diskInfoManager, geoStrategyProvider, bazingaTaskManager,
                shareInfoManager);
    }

    @Bean
    public FacesAlbumManager facesAlbumManager(AlbumDao albumDao,
                                               AlbumFaceClustersDao albumFaceClustersDao,
                                               AlbumItemDao albumItemDao,
                                               Blackbox2 blackbox2,
                                               DiskSearchHttpClient diskSearchHttpClient,
                                               DjfsResourceDao djfsResourceDao,
                                               UserDao userDao,
                                               AlbumDeltaDao albumDeltaDao,
                                               XivaPushGenerator xivaPushGenerator,
                                               TransactionUtils transactionUtils,
                                               ShareInfoManager shareInfoManager
    ) {
        return new FacesAlbumManager(
                albumDao,
                albumItemDao,
                albumFaceClustersDao,
                blackbox2,
                diskSearchHttpClient,
                djfsResourceDao,
                userDao,
                albumDeltaDao,
                xivaPushGenerator,
                transactionUtils,
                shareInfoManager
        );
    }

    @Bean
    public FavoritesAlbumManager favoritesAlbumManager(DjfsResourceDao djfsResourceDao,
                                                       ShareInfoManager shareInfoManager,
                                                       AlbumItemDao albumItemDao,
                                                       AlbumDao albumDao,
                                                       AlbumDeltaDao albumDeltaDao,
                                                       XivaPushGenerator xivaPushGenerator,
                                                       TransactionUtils transactionUtils
    ) {
        return new FavoritesAlbumManager(
                djfsResourceDao,
                shareInfoManager,
                albumItemDao,
                albumDao,
                albumDeltaDao,
                xivaPushGenerator,
                transactionUtils
        );
    }

    @Bean
    public PersonalAlbumManager personalAlbumManager(DjfsResourceDao djfsResourceDao, ShareInfoManager shareInfoManager,
            AlbumItemDao albumItemDao, AlbumDao albumDao, AlbumDeltaDao albumDeltaDao, XivaPushGenerator xivaPushGenerator,
            TransactionUtils transactionUtils)
    {
        return new PersonalAlbumManager(djfsResourceDao, shareInfoManager, albumItemDao, albumDao, albumDeltaDao,
                xivaPushGenerator, transactionUtils);
    }

    @Bean
    public AlbumMergeManager albumMergeManager(FacesAlbumManager facesAlbumManager,
                                               OperationDao operationDao, BazingaTaskManager bazingaTaskManager,
                                               XivaPushGenerator xivaPushGenerator)
    {
        return new AlbumMergeManager(facesAlbumManager, operationDao, bazingaTaskManager, xivaPushGenerator);
    }
}
