package ru.yandex.chemodan.app.djfs.core.album;

import org.bson.types.ObjectId;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.Sharded;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author eoshch
 */
public interface AlbumDao {
    @Sharded
    void deleteAll(DjfsUid uid);

    @Sharded
    void insert(Album album);

    @Sharded
    ListF<Album> getAlbums(DjfsUid uid, AlbumType type);

    @Sharded
    ListF<ExtendedAlbum> getExtendedAlbums(DjfsUid uid, ListF<AlbumType> types);

    @Sharded
    long getMaxAlbumVersion(DjfsUid uid);

    @Sharded
    ListF<Album> findAlbums(DjfsUid uid, CollectionF<ObjectId> albumIds);

    @Sharded
    Option<Album> findGeoAlbum(DjfsUid uid, long regionId);

    @Sharded
    Option<ExtendedAlbum> findExtendedGeoAlbum(DjfsUid uid, long regionId);

    @Sharded
    boolean updateAlbumRevision(Album album, long albumRevision);

    @Sharded
    boolean updateAlbumRevision(Album album, long revision, Option<Instant> dateModified);

    @Sharded
    void incrementAlbumRevision(Album album);

    @Sharded
    boolean updateAlbumsRevision(ListF<Album> albums, DjfsUid uid, long revision);

    @Sharded
    boolean updateAlbumsRevision(ListF<Album> albums, DjfsUid uid, long revision, Option<Instant> dateModified);

    @Sharded
    void makeVisible(Album album);

    @Sharded
    void setCover(Album album, ObjectId coverItemId);

    @Sharded
    void setTitle(Album album, String title);

    @Sharded
    void setParams(Album album, ListF<AlbumParam> params);

    @Sharded
    void updateDateModified(Album album, Instant dateModified);

    @Sharded
    boolean delete(Album album);

    @Sharded
    void makeHidden(Album album);

    @Sharded
    Option<Album> findAlbum(DjfsUid uid, ObjectId albumId);

    @Sharded
    Option<ExtendedAlbum> findExtendedAlbum(DjfsUid uid, ObjectId albumId);

    @Sharded
    void setCoverAuto(Album album, boolean coverAuto);
}
