package ru.yandex.chemodan.app.djfs.core.album;

import lombok.Builder;
import lombok.Value;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.DjfsUidSource;
import ru.yandex.chemodan.app.djfs.core.db.mongo.DjfsBenderFactory;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.BenderParserSerializer;

@Value
@Builder
public class AlbumDelta implements DjfsUidSource {
    public static final BenderParserSerializer<AlbumDeltaChange> B =
            new BenderMapper(DjfsBenderFactory.defaultConfiguration).createParserSerializer(AlbumDeltaChange.class);

    public final DjfsUid uid;
    public final String id;
    @Builder.Default
    public final Option<Long> revision = Option.empty();
    public final ListF<AlbumDeltaChange> changes;
    public final Option<Instant> dateCreated;
    public final Option<AlbumType> albumType;

    public AlbumDelta withRevision(long revision) {
        return new AlbumDelta(uid, id, Option.of(revision), changes, dateCreated, albumType);
    }

    public long getRevision() {
        return revision.get();
    }
}
