package ru.yandex.chemodan.app.djfs.core.album;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.Sharded;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

public interface AlbumDeltaDao {
    @Sharded
    void insert(AlbumDelta delta);

    @Sharded
    ListF<AlbumDeltaRaw> findRaw(DjfsUid uid);

    @Sharded
    void deleteAll(DjfsUid uid);

    @Sharded
    Option<AlbumDeltaRaw> findRaw(DjfsUid uid, long revision);

    @Sharded
    ListF<AlbumDeltaRaw> findRaw(DjfsUid uid, long minRevision, long maxRevision, int limit);

    @Sharded
    int count(DjfsUid uid, long minRevision, long maxRevision);

    @Sharded
    Option<Long> getCurrentRevisionWithLock(DjfsUid uid);

    @Sharded
    Option<Long> getCurrentRevisionWithoutLock(DjfsUid uid);

    @Sharded
    void updateCurrentRevision(DjfsUid uid, long value);

    @Sharded
    boolean tryInitializeCurrentRevision(DjfsUid uid);

    // WARNING! for test purposes only
    @Sharded
    void removeCurrentRevision(DjfsUid uid);
}
