package ru.yandex.chemodan.app.djfs.core.album;

import lombok.Builder;
import lombok.Value;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

@Value
@Builder
@BenderBindAllFields
public class AlbumDeltaFieldChange {
    @BenderPart(name = "field_id", strictName = true)
    public final String fieldId;
    @BenderPart(name = "change_type", strictName = true)
    public final AlbumDeltaFieldChangeType changeType;
    public final Option<AlbumItemFieldValue> value;

    public static AlbumDeltaFieldChange set(AlbumItemField field) {
        return new AlbumDeltaFieldChange(field.fieldId, AlbumDeltaFieldChangeType.SET, Option.of(field.value));
    }
}
