package ru.yandex.chemodan.app.djfs.core.album;

import org.bson.types.ObjectId;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.Sharded;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

public interface AlbumFaceClustersDao {
    @Sharded
    void insert(DjfsUid uid, ObjectId albumId, String clusterId);

    @Sharded
    ListF<String> getClusters(DjfsUid uid, ObjectId albumId);

    @Sharded
    void deleteAll(DjfsUid uid);

    @Sharded
    void deleteAll(DjfsUid uid, ObjectId albumId);

    @Sharded
    int changeAlbumId(DjfsUid uid, ObjectId srcAlbumId, ObjectId dstAlbumId);

    @Sharded
    Option<ObjectId> getAlbum(DjfsUid uid, String clusterId);
}
