package ru.yandex.chemodan.app.djfs.core.album;

import lombok.Builder;
import lombok.Data;
import org.bson.types.ObjectId;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.DjfsUidSource;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsFileId;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author eoshch
 */
@Builder
@Data
public class AlbumItem implements DjfsUidSource {
    ObjectId id;
    DjfsUid uid;
    ObjectId albumId;
    String objectId;
    AlbumItemType objectType;
    Option<String> description;
    Option<Double> orderIndex;
    Option<String> groupId;
    Option<FaceInfo> faceInfo;
    Option<Instant> dateCreated;

    public AlbumItem withAlbumId(ObjectId newAlbumId) {
        return new AlbumItem(id, uid, newAlbumId,
                objectId, objectType, description, orderIndex, groupId, faceInfo, dateCreated);
    }

    public static AlbumItem cons(Album album, DjfsFileId fileId, Option<Double> orderIndex, Option<FaceInfo> faceInfo) {
        return AlbumItem.builder()
                .id(new ObjectId())
                .albumId(album.getId())
                .description(Option.empty())
                .groupId(Option.empty())
                .uid(album.getUid())
                .objectId(fileId.getValue())
                .objectType(AlbumItemType.RESOURCE)
                .orderIndex(orderIndex)
                .faceInfo(faceInfo)
                .dateCreated(Option.of(Instant.now()))
                .build();
    }
}
