package ru.yandex.chemodan.app.djfs.core.album;

import org.bson.types.ObjectId;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.djfs.core.db.Sharded;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author eoshch
 */
public interface AlbumItemDao {
    @Sharded
    void deleteAll(DjfsUid uid);

    @Sharded
    ListF<AlbumItem> getAllAlbumItems(DjfsUid uid, ListF<ObjectId> albumIds, int limit);  // TODO: choose something else other than ObjectId

    @Sharded
    ListF<AlbumItem> getAllAlbumItems(DjfsUid uid, ObjectId albumId);

    @Sharded
    void insert(AlbumItem item);

    @Sharded
    ListF<AlbumItem> findObjectInAlbum(DjfsUid uid, ObjectId albumId, String objectId);

    @Sharded
    Option<AlbumItem> findByItemId(DjfsUid uid, String albumItemId);

    @Sharded
    ListF<AlbumItem> findObjectsInAlbum(DjfsUid uid, ObjectId albumId, ListF<String> objectsIds);

    @Sharded
    ListF<AlbumItem> find(DjfsUid uid, String objectId);  // WARNING! potentially dangerous method: no suitable index

    @Sharded
    int countObjectsInAlbum(DjfsUid uid, ObjectId albumId);

    @Sharded
    boolean removeFromAlbum(DjfsUid uid, ObjectId albumId, String objectId);

    @Sharded
    boolean removeFromAlbum(DjfsUid uid, ObjectId albumId, SetF<String> objectIds);

    @Sharded
    int removeAllItemsFromAlbum(DjfsUid uid, ObjectId albumId);

    @Sharded
    ListF<int[]> batchInsert(DjfsUid uid, ListF<AlbumItem> albumItems);

    @Sharded
    int changeAlbumId(DjfsUid uid, ObjectId srcAlbumId, ObjectId dstAlbumId);

    @Sharded
    ListF<AlbumItem> getExistingAlbumItems(DjfsUid uid, ObjectId albumId);

    @Sharded
    long getAlbumItemCount(Album album);
}
