package ru.yandex.chemodan.app.djfs.core.album;

import lombok.Data;

import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author zero-ger
 */

@BenderBindAllFields
@Data
public class AlbumItemFaceBorders {
    final public double borderMin;
    final public double borderMax;
    final public boolean needResize;

    public AlbumItemFaceBorders(double borderMin, double borderMax) {
        this.borderMin = borderMin;
        this.borderMax = borderMax;
        this.needResize = false;
    }

    public AlbumItemFaceBorders(double borderMin, double borderMax, boolean needResize) {
        this.borderMin = borderMin;
        this.borderMax = borderMax;
        this.needResize = needResize;
    }

    public AlbumItemFaceBorders shiftBorders() {
        double newBorderMin = borderMin;
        double newBorderMax = borderMax;
        boolean newNeedResize = false;

        if (borderMax - borderMin >= 1) {
            newBorderMin = 0d;
            newBorderMax = 1d;
            newNeedResize = true;
        } else if(borderMin <= 0) {
            newBorderMin = 0d;
            newBorderMax = Math.min(borderMax - borderMin, 1d);
        } else if(borderMax >= 1) {
            newBorderMax = 1d;
            newBorderMin = Math.max(borderMin - (borderMax - 1), 0d);
        }
        return new AlbumItemFaceBorders(newBorderMin, newBorderMax, newNeedResize);
    }

    public double getPxSize(double photoSize){
        return photoSize * (borderMax-borderMin);
    }
}
