package ru.yandex.chemodan.app.djfs.core.album;

import org.joda.time.Instant;

import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

@BenderBindAllFields
public class AlbumItemField {
    @BenderPart(name = "field_id", strictName = true)
    public final String fieldId;
    public final AlbumItemFieldValue value;

    public AlbumItemField(String fieldId, AlbumItemFieldValue value) {
        this.fieldId = fieldId;
        this.value = value;
    }

    public static AlbumItemField stringField(String fieldId, String value) {
        return new AlbumItemField(
                fieldId,
                new AlbumItemFieldValue(AlbumItemFieldType.STRING, value)
        );
    }

    public static AlbumItemField integerField(String fieldId, int value) {
        return new AlbumItemField(
                fieldId,
                new AlbumItemFieldValue(AlbumItemFieldType.INTEGER, value)
        );
    }

    public static AlbumItemField longField(String fieldId, long value) {
        return new AlbumItemField(
                fieldId,
                new AlbumItemFieldValue(AlbumItemFieldType.INTEGER, value)
        );
    }

    public static AlbumItemField doubleField(String fieldId, double value) {
        return new AlbumItemField(
                fieldId,
                new AlbumItemFieldValue(AlbumItemFieldType.DOUBLE, value)
        );
    }

    public static AlbumItemField booleanField(String fieldId, boolean value) {
        return new AlbumItemField(
                fieldId,
                new AlbumItemFieldValue(AlbumItemFieldType.BOOLEAN, value)
        );
    }

    public static AlbumItemField instantField(String fieldId, Instant value) {
        return new AlbumItemField(
                fieldId,
                new AlbumItemFieldValue(AlbumItemFieldType.DATETIME, value)
        );
    }
}
