package ru.yandex.chemodan.app.djfs.core.album;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;


public enum AlbumItemType implements StringEnum {
    RESOURCE,
    ALBUM,
    SHARED_RESOURCE
    ;

    private final String value;

    AlbumItemType() {
        this.value = name().toLowerCase();
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<AlbumItemType> R = StringEnumResolver.r(AlbumItemType.class);
}
