package ru.yandex.chemodan.app.djfs.core.album;

import org.bson.types.ObjectId;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.djfs.core.album.operation.albummerge.AlbumMergeOperation;
import ru.yandex.chemodan.app.djfs.core.album.operation.albummerge.AlbumMergeTask;
import ru.yandex.chemodan.app.djfs.core.notification.XivaPushGenerator;
import ru.yandex.chemodan.app.djfs.core.operations.Operation;
import ru.yandex.chemodan.app.djfs.core.operations.OperationDao;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.bazinga.BazingaTaskManager;

/**
 * @author yashunsky
 */
public class AlbumMergeManager {

    private final FacesAlbumManager facesAlbumManager;
    private final OperationDao operationDao;
    private final BazingaTaskManager bazingaTaskManager;
    private final XivaPushGenerator xivaPushGenerator;

    protected AlbumMergeManager(FacesAlbumManager facesAlbumManager, OperationDao operationDao,
                                BazingaTaskManager bazingaTaskManager, XivaPushGenerator xivaPushGenerator) {
        this.facesAlbumManager = facesAlbumManager;
        this.operationDao = operationDao;
        this.bazingaTaskManager = bazingaTaskManager;
        this.xivaPushGenerator = xivaPushGenerator;
    }

    public Operation mergeFaceAlbumsAsync(DjfsUid uid, ObjectId srcAlbumId, ObjectId dstAlbumId) {
        AlbumType type = AlbumType.FACES;
        facesAlbumManager.getAlbumsWithTypeCheck(uid, Cf.list(srcAlbumId, dstAlbumId));

        Operation operation = AlbumMergeOperation.create(uid, srcAlbumId, dstAlbumId, type);
        operationDao.insert(operation);
        bazingaTaskManager.schedule(new AlbumMergeTask(uid, operation.getId(), srcAlbumId, dstAlbumId, type));
        xivaPushGenerator.sendOperationCreatedPush(uid, operation);

        return operation;
    }

    public void mergeFaceAlbums(DjfsUid uid, ObjectId srcId, ObjectId dstId) {
        facesAlbumManager.mergeAlbums(uid, srcId, dstId);
    }
}
