package ru.yandex.chemodan.app.djfs.core.album;

import lombok.Value;
import org.bson.types.ObjectId;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;

@Value
public class AlbumParam {
    private final String name;
    private final Object value;

    private AlbumParam(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    static public AlbumParam title(String value) {
        return new AlbumParam("title", value);
    }

    static public AlbumParam description(String value) {
        return new AlbumParam("description", value);
    }

    static public AlbumParam flags(ListF<String> value) { return new AlbumParam("flags", value); }

    static public AlbumParam layout(AlbumLayoutType value) { return new AlbumParam("layout", value); }

    static public AlbumParam isPublic(boolean value) {
        return new AlbumParam("is_public", value);
    }

    static public AlbumParam cover(ObjectId value) {
        return new AlbumParam("cover_id", value.toByteArray());
    }

    static public AlbumParam coverAuto(boolean value) {
        return new AlbumParam("cover_auto", value);
    }

    static public AlbumParam coverOffsetY(double value) {
        return new AlbumParam("cover_offset_y", value);
    }

    static public AlbumParam fotkiAlbumId(Long value) { return new AlbumParam("fotki_album_id", value); }

    static public AlbumParam dateModified(Instant value) {return new AlbumParam("date_modified", value); }
}
