package ru.yandex.chemodan.app.djfs.core.album;


import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

public enum AlbumType implements StringEnum {
    PERSONAL,
    GEO,
    FAVORITES,
    FACES,
    DOCUMENTS
    ;

    private final String value;

    AlbumType() {
        this.value = name().toLowerCase();
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<AlbumType> R = StringEnumResolver.r(AlbumType.class);
}
