package ru.yandex.chemodan.app.djfs.core.album;

import org.bson.types.ObjectId;

import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.commune.a3.action.http.HttpStatusCodeSource;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author yashunsky
 */
public class AlbumTypeMismatchException extends DjfsException implements HttpStatusCodeSource {
    public AlbumTypeMismatchException(ObjectId albumId, AlbumType expected, AlbumType actual) {
        super("Type mismatch for album " + albumId + ": " + expected + " expected while got " + actual);
    }

    @Override
    public int getHttpStatusCode() {
        return HttpStatus.SC_400_BAD_REQUEST;
    }
}
