package ru.yandex.chemodan.app.djfs.core.album;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.djfs.core.tasks.DjfsCeleryOnetimeTask;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.queller.worker.CeleryOnetimeTaskParameters;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.json.JsonString;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;


public class CatchupAlbumCreationHandler extends DjfsCeleryOnetimeTask {

    private static final Logger logger = LoggerFactory.getLogger(CatchupAlbumCreationHandler.class);

    public static final TaskId TASK_ID = new TaskId("mpfs.core.albums.job_handlers.handle_start_album_creation");

    private final GeoAlbumManager geoAlbumManager;

    public CatchupAlbumCreationHandler(GeoAlbumManager geoAlbumManager) {
        this.geoAlbumManager = geoAlbumManager;
    }

    @Override
    protected void handle(CeleryOnetimeTaskParameters parameters, ExecutionContext context) {
        JsonString uidString = (JsonString) (parameters.kwargs.getO("uid").get());
        DjfsUid uid = DjfsUid.cons(uidString.getString());
        geoAlbumManager.startAlbumCreationProcess(uid);
    }

    @Override
    protected TaskId celeryTaskId() {
        return TASK_ID;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(1);
    }
}
