package ru.yandex.chemodan.app.djfs.core.album;

import org.bson.types.ObjectId;

public class CollectionId {
    public static final String ALBUM_LIST_COLLECTION_ID = "index";
    private static final String ALBUMS_COLLECTION_ID = "albums";

    public static String formatAlbumCollectionId(Album album) {
        return formatAlbumCollectionId(album.getId());
    }

    public static String formatAlbumCollectionId(ObjectId albumId) {
        return albumId.toHexString();
    }

    public static String formatAlbumsDatabaseId() {
        return ALBUMS_COLLECTION_ID;
    }

    public static ObjectId parseAlbumCollectionId(String collectionId) {
        return new ObjectId(collectionId);
    }
}
