package ru.yandex.chemodan.app.djfs.core.album;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FileDjfsResource;
import ru.yandex.inside.geobase.Geobase;
import ru.yandex.inside.geobase.RegionNode;
import ru.yandex.inside.geobase.RegionType;

public class DefaultCityStrategy {

    private final Geobase geobase;

    private ListF<RegionType> ALBUM_REGION_TYPES = Cf.list(
            RegionType.FEDERAL_SUBJECT,
            RegionType.CITY,
            RegionType.VILLAGE,
            RegionType.CITY_DISTRICT,
            RegionType.CITY_MICRODISTRICT,
            RegionType.SETTLEMENT
    );

    public DefaultCityStrategy(Geobase geobase) {
        this.geobase = geobase;
    }

    protected MapF<RegionType, Integer> getRegionSpecificIds(MapF<RegionType, Integer> allRegions) {
        return Cf.map();
    }

    public MapF<RegionType, Integer> get(FileDjfsResource resource) {
        MapF<RegionType, Integer> allRegionIds = getAllRegionIds(resource);

        MapF<RegionType, Integer> result = Cf.hashMap();
        getRegionSpecificIds(allRegionIds).entries().forEach(t -> result.put(t));

        if (allRegionIds.containsKeyTs(RegionType.CITY)) {
            result.put(RegionType.CITY, allRegionIds.getOrThrow(RegionType.CITY));
        }
        if (allRegionIds.containsKeyTs(RegionType.FEDERAL_SUBJECT)) {
            result.put(RegionType.FEDERAL_SUBJECT, allRegionIds.getOrThrow(RegionType.FEDERAL_SUBJECT));
        }

        return result;
    }

    protected MapF<RegionType, Integer> getAllRegionIds(FileDjfsResource resource) {
        Option<RegionNode> regionO = resource.getCoordinates().flatMapO(geobase::getRegionIdByCoordinates)
                .flatMapO(geobase::getRegionById);

        if (!regionO.isPresent()) {
            return Cf.map();
        }

        return ALBUM_REGION_TYPES
                .map(t -> Tuple2.tuple(t, getRegionNodeByType(regionO, t)))
                .filter(t -> t._2.isPresent())
                .toMap(t -> Tuple2.tuple(t._1, t._2.get().getId()));
    }

    private Option<RegionNode> getRegionNodeByType(Option<RegionNode> nodeO, RegionType type) {
        if (!nodeO.isPresent()) {
            return Option.empty();
        }
        return nodeO.get().getType() == type ? nodeO : geobase.getParentByType(nodeO, type);
    }
}
