package ru.yandex.chemodan.app.djfs.core.album;

import lombok.Value;

import ru.yandex.bolts.collection.Lazy;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourceId;
import ru.yandex.commune.json.JsonNull;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonString;

public class FaceInfo {
    /**
     * We keep raw JSON for compatibility with future changes.
     */
    private final JsonObject data;

    public FaceInfo(JsonObject data) {
        this.data = data;
        this.parsed = Lazy.withSupplier(() ->
                new FaceInfoDto(
                        Double.parseDouble( ((JsonString)data.get("face_coord_x")).getValue() ),
                        Double.parseDouble( ((JsonString)data.get("face_coord_y")).getValue() ),
                        Double.parseDouble( ((JsonString)data.get("face_height" )).getValue() ),
                        Double.parseDouble( ((JsonString)data.get("face_width"  )).getValue() ),
                        Integer.parseInt(   ((JsonString)data.get("height"      )).getValue() ),
                        Integer.parseInt(   ((JsonString)data.get("width"       )).getValue() ),
                        /**/                ((JsonString)data.get("resource_id" )).getValue()  ,
                        data.getO("cost_disk_aethetic_0")
                                .filterByType(JsonString.class)
                                .map(j -> Double.parseDouble(j.getValue()))
                ));
    }

    public FaceInfo(MapF<String, /*nullable*/ String> m) {
        this(new JsonObject(m.mapValues(v -> v != null ? JsonString.valueOf(v) : JsonNull.NULL)));
    }

    public String serializeJson() {
        return data.serialize();
    }

    public static ru.yandex.chemodan.app.djfs.core.album.FaceInfo parseJson(String s) {
        return new ru.yandex.chemodan.app.djfs.core.album.FaceInfo(JsonObject.parseObject(s));
    }

    @Value
    private static class FaceInfoDto {
        double          faceCoordX;
        double          faceCoordY;
        double          faceHeight;
        double          faceWidth;
        int             height;
        int             width;
        String          resourceId;
        Option<Double>  aesthetic;
    }

    private final Lazy<FaceInfoDto> parsed;

    public double getFaceCoordX() {
        return parsed.get().getFaceCoordX();
    }

    public double getFaceCoordY() {
        return parsed.get().getFaceCoordY();
    }

    public double getFaceHeight() {
        return parsed.get().getFaceHeight();
    }

    public double getFaceWidth() {
        return parsed.get().getFaceWidth();
    }

    public int getHeight() {
        return parsed.get().getHeight();
    }

    public int getWidth() {
        return parsed.get().getWidth();
    }

    public DjfsResourceId getResourceId() {
        return DjfsResourceId.cons(parsed.get().getResourceId());
    }

    public AlbumItemFaceCoordinates getCoordinates() {
        return new AlbumItemFaceCoordinates(this);
    }

    public Option<Double> getAesthetic() {
        return parsed.get().getAesthetic();
    }
}
