package ru.yandex.chemodan.app.djfs.core.album;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.a3.action.http.HttpStatusCodeSource;
import ru.yandex.misc.io.http.HttpStatus;

public class FeatureUnavailableInUserCountryException extends DjfsException implements HttpStatusCodeSource {
    public FeatureUnavailableInUserCountryException(DjfsUid uid, Option<String> country) {
        super("The feature is not available in the user " + uid.asString() + " country " + country.getOrElse(""));
    }

    @Override
    public int getHttpStatusCode() {
        return HttpStatus.SC_451_UNAVAILABLE_FOR_LEGAL_REASONS;
    }
}
